% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{threshold}
\alias{threshold}
\title{Threshold}
\usage{
threshold(your_data, thresh = 5e-04, thresh_type = "relative")
}
\arguments{
\item{your_data}{A data frame. Usually individual barcodes in rows and samples in columns.}

\item{thresh}{Numeric.}

\item{thresh_type}{Character. One of "relative" or "absolute"}
}
\value{
A data frame where all rows (barcodes) that did not have at least one element meet the threshold have been discarded.
}
\description{
This is a helper which function takes in sequence data in table form, along with a threshold,
to each column (e.g. if threshold is set as 0.0005, only rows in which an element is above 0.05% of
its column will be kept).
}
\examples{
data(wu_subset)
threshold(SummarizedExperiment::assay(wu_subset, assay = "counts"),
    thresh = 0.0005
)
}
