% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_hist.R
\name{stat_hist}
\alias{stat_hist}
\title{Stat histogram}
\usage{
stat_hist(
  your_SE,
  data_choice = "assay stats",
  assay_choice = "counts",
  metadata_stat = NULL,
  group_meta_by = NULL,
  scale_all_y = FALSE,
  y_log_axis = FALSE,
  text_size = 12,
  n_bins = 30,
  n_cols = NULL,
  your_title = NULL
)
}
\arguments{
\item{your_SE}{Your SummarizedExperiment of barcode data and associated metadata.}

\item{data_choice}{Either "assay stats" which allows you to view the distribution of values in the `assay_choice` assay, or "metadata stats" which allows you to view the distribution of metadata values in your SummarizedExperiment object.}

\item{assay_choice}{When data_choice is set to "assay stats", designates which assay will be used.}

\item{metadata_stat}{When data_choice is set to "metadata stats", The metadata values that will be used.}

\item{group_meta_by}{When data_choice is set to "metadata stats", facet the histogram using this column of metadata. If NULL, no grouping or faceting applied}

\item{scale_all_y}{Logical. Whether or not to plot all plots on the same y axis limits.}

\item{y_log_axis}{Logical. Whether or not to put y axis on log scale}

\item{text_size}{Size of text.}

\item{n_bins}{Number of bins for histograms. Default is 30.}

\item{n_cols}{Number of columns for faceted histograms. If NULL (default) will automatically choose n_cols for facetting.}

\item{your_title}{Character. The title for the plot.}
}
\value{
Histogram of chosen statistics
}
\description{
Given a summarized experiment, gives a histogram of the acc assay or choice of metadata.
}
\examples{
data(wu_subset)
stat_hist(
    your_SE = wu_subset[, 1], data_choice = "assay stats",
    assay_choice = "counts"
)
}
