% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_plot.R
\name{scatter_plot}
\alias{scatter_plot}
\title{Scatter Plot}
\usage{
scatter_plot(
  your_SE,
  assay = "proportions",
  plot_labels = colnames(your_SE),
  method_corr = "pearson",
  display_corr = TRUE,
  point_size = 0.5,
  your_title = "",
  text_size = 12
)
}
\arguments{
\item{your_SE}{A Summarized Experiment object of two samples.}

\item{assay}{The choice of assay to plot on the scatter plot. Set to "proportions" by default.}

\item{plot_labels}{The labels for the X and Y axis of the plot}

\item{method_corr}{Character. One of "pearson", "spearman", or "kendall". Can also use "manhattan" to compute manhattan distance instead.}

\item{display_corr}{Logical. Whether to display the computer correlation or not.}

\item{point_size}{Numeric. The size of the points being plotted.}

\item{your_title}{Logical. The title for the plot.}

\item{text_size}{Numeric. Size of text in plot.}
}
\value{
Displays a scatter plot of the specified assay for the specified samples in your_SE with correlation value optionally displayed.
}
\description{
Plots a scatter plot of two samples in the Summarized Experiment object
}
\examples{
data(wu_subset)
scatter_plot(your_SE = wu_subset[, c(4, 8)])
# "
}
