% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds_plot.R
\name{mds_plot}
\alias{mds_plot}
\title{MDS Plot}
\usage{
mds_plot(
  your_SE,
  group_by = "SAMPLENAME",
  method_dist = "bray",
  assay = "proportions",
  your_title = NULL,
  point_size = 3,
  text_size = 12,
  return_table = FALSE,
  kmeans_cluster = FALSE,
  k.param = 3,
  draw_ellipses = FALSE
)
}
\arguments{
\item{your_SE}{Summarized Experiment object containing clonal tracking data as created by the barcodetrackR `create_SE` function.}

\item{group_by}{Column of metadata to color samples by. Can also specify "kmeans_cluster" if kmeans_cluster argument is set to TRUE, and then the grouping variables will be the clusterinng result.}

\item{method_dist}{Dissimilarity index from vegan. One of "manhattan", "euclidean", "canberra", "clark", "bray", "kulczynski", "jaccard", "gower", "altGower", "morisita", "horn", "mountford", "raup", "binomial", "chao", or "cao".}

\item{assay}{The assay to calculate the index on}

\item{your_title}{Character. The title for the plot.}

\item{point_size}{Numeric. The size of the points.}

\item{text_size}{Numeric. Size of text in plot.}

\item{return_table}{Logical. If set to true, the function will return a dataframe containing each samples reduced measure of dissimilarity coordinates.}

\item{kmeans_cluster}{Logical. If set to true, each sample will be assigned a cluster computed by kmeans on the chosen assay.}

\item{k.param}{Numeric. If kmeans_cluster is TRUE, provide the number of kmeans clusters to identify.}

\item{draw_ellipses}{Logical. If kmeans_cluster is TRUE, draw ellipses around the different kmeans clusters.}
}
\value{
Plots dissimilarity indices between samples in your_SE. Or if return table is set to TRUE, returns a dataframe of each sample's reduced measures of dissimilarity coordinates.
}
\description{
Calculates a simmilarity/dissimlarity index or metrix for each sample-sample pair and reduces the resulting dist matrix into two dimensions
}
\examples{
data(wu_subset)
mds_plot(your_SE = wu_subset, method_dist = "bray", group_by = "celltype")
# "
}
