% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_top_clones.R
\name{get_top_clones}
\alias{get_top_clones}
\title{get_top_clones (helper function)}
\usage{
get_top_clones(your_SE, SAMPLENAME_choice, n_clones = 10)
}
\arguments{
\item{your_SE}{A summarized experiment.}

\item{SAMPLENAME_choice}{Name of the SAMPLENAME identifier within your_SE from which to retrieve the top clones from.}

\item{n_clones}{Numeric. Number of top clones from the specified sample that should be retrieved.}
}
\value{
The row indices for the top n_clones in the dataset, using the 'ranks' assay.
}
\description{
Retrieves the sequence(s) (row-identifier(s)) of the top "n_clones" within the specified sample from a SummarizedExperiment object.
}
\examples{
data(wu_subset)
get_top_clones(wu_subset, "ZJ31_6m_T", n_clones = 10)
}
