% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_plot.R
\name{dist_plot}
\alias{dist_plot}
\title{Pairwise Distance Plot}
\usage{
dist_plot(
  your_SE,
  assay = "proportions",
  plot_labels = colnames(your_SE),
  dist_method = "euclidean",
  cluster_tree = FALSE,
  your_title = "",
  grid = TRUE,
  label_size = 10,
  plot_type = "color",
  no_negatives = FALSE,
  return_table = FALSE,
  color_pal = "Blues",
  number_size = 3,
  point_scale = 5,
  minkowski_p = 2
)
}
\arguments{
\item{your_SE}{A Summarized Experiment object.}

\item{assay}{The choice of assay to use for the correlation calculation. Set to "proportions" by default.}

\item{plot_labels}{Vector of x axis labels. Defaults to colnames(your_SE).}

\item{dist_method}{Character. Distance OR similarity measure from the `proxy` package. Full list of distance and similarity measures can be found using `summary(proxy::pr_DB)`. Default is "euclidean".
Distances will be calculated for distance measures, while similarities will be calculated for similarity measures. Distance OR similarity measure will be calculated using the `assay`
specified.}

\item{cluster_tree}{Logical. Whether to cluster samples and plot a hierarchical tree calculated from the distance or similarity measure used. Default is FALSE.}

\item{your_title}{Character. The title for the plot.}

\item{grid}{Logical. Include a grid or not in the resulting plot.}

\item{label_size}{Numeric. The size of the column labels.}

\item{plot_type}{Character. One of "color", "circle", or "number".}

\item{no_negatives}{Logical. Whether to make negative correlations = 0.}

\item{return_table}{Logical. Whether or not to return table of p-values, confidence intervals, and R values instead of displaying a plot.}

\item{color_pal}{Character. One of 'Reds', 'Purples', 'Oranges', 'Greys', 'Greens', or 'Blues' that designates the brewer.pal color scale to use.}

\item{number_size}{Numeric. size of the text label when plot_type is "number".}

\item{point_scale}{Numeric. The size of the largest point if the plot_type is "circle".}

\item{minkowski_p}{Numeric. If 'Minkowski' is chosen, the 'p' used to calculate the Minkowski distance.}
}
\value{
Plots pairwise correlation plot for the samples in your_SE.
}
\description{
Plots the pairwise distances of the specified assay between each sample-sample pair in the provided SummarizedExperiment.
}
\examples{
data(wu_subset)
dist_plot(your_SE = wu_subset, plot_type = "color")
# "
}
