% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_SE.R
\name{create_SE}
\alias{create_SE}
\title{create_SE}
\usage{
create_SE(
  your_data = NULL,
  meta_data = NULL,
  threshold = 0,
  threshold_type = "relative",
  log_base = exp(1),
  scale_factor = 1e+06
)
}
\arguments{
\item{your_data}{A data frame. For clonal tracking data, this will be individual barcodes or lineage tracing elements in rows and samples in columns.}

\item{meta_data}{A data frame containing all meta-data. Must, at the very least, include a column called "SAMPLENAME" that contains all of the colnames within the data frame passed as  `your_data` and only those colnames.}

\item{threshold}{Numeric. The minimum threshold abundance for a barcode to be maintained in the SE. If `threshold_type` is relative, this parameter should be between 0 and 1. If `threshold_type` is absolute, this parameter should be greater than 1.}

\item{threshold_type}{Character. One of "relative" or "absolute" relative. If a relative threshold is specified, only those rows which have higher than `threshold` proportion of reads within at least one sample will be kept as non-zero. If an absolute threshold is specified, only those rows which have an absolute read count higher than `threshold` in at least one sample will be kept as non-zero.}

\item{log_base}{A numeric indicating which base to use when logging the normalized data}

\item{scale_factor}{A numeric indicating what scaling factor to use in normalization. For the default value of 1 million, barcode proportions on a per sample basis will be multiplied by 1 million before log+1 normalization.}
}
\value{
Returns a SummarizedExperiment holding your clonal tracking data and the associated metadata.
}
\description{
Creates a SummarizedExperiment object from a data frame containing clonal tracking counts (`your_data`) with rows as observations and columns as samples, and the associated metadata (`meta_data`) with rows as samples and columns of information describing those samples.
}
\examples{
count_path <- system.file("extdata",
    "/WuC_etal_appdata/sample_data_ZJ31.txt",
    package = "barcodetrackR"
)
wu_dataframe <- read.delim(count_path, row.names = 1)
metadata_path <- system.file("extdata",
    "/WuC_etal_appdata/sample_metadata_ZJ31.txt",
    package = "barcodetrackR"
)
wu_metadata <- read.delim(metadata_path)
wu_SE <- create_SE(
    your_data = wu_dataframe, meta_data = wu_metadata,
    threshold = 0
)
}
