% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_plot.R
\name{cor_plot}
\alias{cor_plot}
\title{Correlation Plot}
\usage{
cor_plot(
  your_SE,
  assay = "proportions",
  plot_labels = colnames(your_SE),
  method_corr = "pearson",
  your_title = "",
  grid = TRUE,
  label_size = 8,
  plot_type = "color",
  no_negatives = FALSE,
  return_table = FALSE,
  color_scale = "default",
  number_size = 3,
  point_scale = 1
)
}
\arguments{
\item{your_SE}{A Summarized Experiment object.}

\item{assay}{The choice of assay to use for the correlation calculation. Set to "proportions" by default.}

\item{plot_labels}{Vector of x axis labels. Defaults to colnames(your_SE).}

\item{method_corr}{Character. One of "pearson", "spearman", or "kendall".}

\item{your_title}{Character. The title for the plot.}

\item{grid}{Logical. Include a grid or not in the correlation plot}

\item{label_size}{Numeric. The size of the column labels.}

\item{plot_type}{Character. One of "color", "circle", or "number".}

\item{no_negatives}{Logical. Whether to make negative correlations = 0.}

\item{return_table}{Logical. Whether or not to return table of p-values, confidence intervals, and R values instead of displaying a plot.}

\item{color_scale}{Character. Either "default" or an odd-numbered color scale where the lowest value will correspond to -1, the median value to 0, and the highest value to 1.}

\item{number_size}{Numeric. Size of the text label when plot_type is "number".}

\item{point_scale}{Numeric. The size of the largest point if the plot_type is "circle"}
}
\value{
Plots pairwise correlation plot for the samples in your_SE.
}
\description{
Plots the pairwise correlation between the specified assay of each sample-sample pair in the provided SummarizedExperiment.
}
\examples{
data(wu_subset)
cor_plot(your_SE = wu_subset, plot_type = "color")
# "
}
