% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonal_count.R
\name{clonal_count}
\alias{clonal_count}
\title{Clonal count plot}
\usage{
clonal_count(
  your_SE,
  percent_threshold = 0,
  plot_over,
  plot_over_display_choices = NULL,
  keep_numeric = TRUE,
  group_by,
  group_by_choices = NULL,
  cumulative = FALSE,
  point_size = 3,
  line_size = 2,
  text_size = 12,
  your_title = NULL,
  return_table = FALSE
)
}
\arguments{
\item{your_SE}{Summarized Experiment object containing clonal tracking data as created by the barcodetrackR `create_SE` function.}

\item{percent_threshold}{Numeric. The percent threshold for which to count barcodes as present or not present. Set to 0 by default.}

\item{plot_over}{The column of metadata that you want to be the x-axis of the plot. e.g. timepoint}

\item{plot_over_display_choices}{Choice(s) from the column designated in plot_over that will be used for plotting. Defaults to all if left as NULL.}

\item{keep_numeric}{If plot_over is numeric, whether to space the x-axis appropriately according to the numerical values.}

\item{group_by}{The column of metadata you want to group by e.g. cell_type.}

\item{group_by_choices}{Choice(s) from the column designated in group_by that will be used for plotting. Defaults to all if left as NULL.}

\item{cumulative}{Logical. If TRUE, will plot cumulative counts over the `plot_over` argument rather than unique counts per sample (the default, which is FALSE).}

\item{point_size}{Numeric. Size of points.}

\item{line_size}{Numeric. Size of lines.}

\item{text_size}{Numeric. Size of text in plot.}

\item{your_title}{The title for the plot.}

\item{return_table}{Logical. If set to true, rather than returning a plot, the function will return the clonal count or cumulative count of each sample in a dataframe.}
}
\value{
Outputs plot of a diversity measure tracked for groups over a factor. Or if return_table is set to TRUE, a dataframe of the number of clones (or cumulative clones) for each sample.
}
\description{
A line plot that tracks the total number of clones or the cumulative number of clones from selected samples of the SummarizedExperiment object plotted over a specified variable.
}
\examples{
data(wu_subset)
clonal_count(your_SE = wu_subset, cumulative = FALSE, plot_over = "months", group_by = "celltype")
}
