% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chord_diagram.R
\name{chord_diagram}
\alias{chord_diagram}
\title{Barcode Chord Diagram}
\usage{
chord_diagram(
  your_SE,
  weighted = FALSE,
  plot_label = "SAMPLENAME",
  alpha = 1,
  your_title = NULL,
  text_size = 12,
  return_table = FALSE
)
}
\arguments{
\item{your_SE}{Summarized Experiment object containing clonal tracking data as created by the barcodetrackR `create_SE` function.}

\item{weighted}{Logical. weighted = F which is default will make links based on the number of shared clones between the factors. Weighted = TRUE will make the link width based on the clone's proportion in the samples.}

\item{plot_label}{Character. Name of colData variable to use as labels for regions. Defaults to SAMPLENAME}

\item{alpha}{Numeric. Transparency of links. Default = 1 is opaque. 0 is completely transluscent}

\item{your_title}{Character. The title for the plot.}

\item{text_size}{Numeric. Size of region labels}

\item{return_table}{Logical. If set to TRUE, in addition to plotting a chord diagram in the plot window, the function will return a dataframe of the shared clonality used to make the chord diagram. If Weighted is FALSE, the dataframe will contain a row for each set of clones and values of 1 or 0 indicating the samples which share that set of clones, and a freq column which is the number of clones in that set. If weighted is set to TRUE, each row will contain a set of clones and the data will show the proportion that set of clones comprises in each sample. The proportions of 0 indicate which samples do not share that set of clones.}
}
\value{
Displays a chord diagram in the current plot window depicting shared clonality between samples (regions) as chords or links between the regions. Or,
}
\description{
Creates a chord diagram showing each cell type (or other factor) as a region around a circle and shared clones between these cell types as links between the regions. The space around the regions which is not connected to a chord indicates clones unique to that sample, not shared with other samples.
}
\examples{
data(wu_subset)
chord_diagram(your_SE = wu_subset[, c(4, 8, 12)], plot_label = "celltype")
}
