% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_ridge_plot.R
\name{bias_ridge_plot}
\alias{bias_ridge_plot}
\title{Bias Ridge plot}
\usage{
bias_ridge_plot(
  your_SE,
  split_bias_on,
  bias_1,
  bias_2,
  split_bias_over,
  bias_over = NULL,
  remove_unique = FALSE,
  weighted = FALSE,
  text_size = 16,
  add_dots = FALSE,
  return_table = FALSE
)
}
\arguments{
\item{your_SE}{Your SummarizedExperiment of barcode data and associated metadata}

\item{split_bias_on}{The column of metadata corresponding to cell types (or whatever factors you want to compare the bias between).}

\item{bias_1}{The first cell type (or other factor) to be compared. Must be a possible value of the split_bias_on column of your metadata. Will be on the RIGHT side of the ridge plot}

\item{bias_2}{The second cell type (or other factor) to be compared. Must be a possible value of the split_bias_on column of your metadata. Will be on the LEFT side of the ridge plot}

\item{split_bias_over}{The column of metadata to plot by. If numeric, y axis will be in increasing order. If categorical, it will follow order of metadata.}

\item{bias_over}{Choice(s) from the column designated in `split_bias_over` that will be used for plotting. Defaults to all.}

\item{remove_unique}{If set to true, only clones present in both samples will be considered.}

\item{weighted}{If true, the density estimation will be weighted by the overall contribution of each barcode to the two samples being compared.}

\item{text_size}{Numeric. The size of the text in the plot.}

\item{add_dots}{Logical. Whether or not to add dots underneath the density plots. Dot size is proportion to the added proportion of the clone in the two samples.}

\item{return_table}{Logical. If true, rather than returning a plot, the function will return a dataframe containing the calculated bias and cumul_sum which contains the added proportion between the two samples, for each barcode sequence across each sample considered.}
}
\value{
Bias plot for two lineages over time. Or a dataframe containing the bias value and added proportion of each barcode if return_table is set to TRUE.
}
\description{
Given a summarized experiment and a specified factor to compare bias between, gives ridge plots which show the density of clones at each value of log bias where log bias is calculated as log((normalized abundance in sample 1 + 1)/(normalized abundance in sample 2 + 1)). If the weighted option is set to TRUE, the density estimator will weight the estimation by the added proportion of the clone between the two samples.
}
\examples{
data(wu_subset)
bias_ridge_plot(
    your_SE = wu_subset, split_bias_on = "celltype",
    bias_1 = "B", bias_2 = "T", split_bias_over = "months",
    add_dots = TRUE
)
}
