% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_histogram.R
\name{bias_histogram}
\alias{bias_histogram}
\title{Bias histogram}
\usage{
bias_histogram(
  your_SE,
  split_bias_on,
  bias_1,
  bias_2,
  split_bias_over,
  bias_over = NULL,
  remove_unique = FALSE,
  breaks = c(10, 2, 1, 0.5),
  text_size = 10,
  linesize = 0.4,
  ncols = 1,
  scale_all_y = TRUE,
  return_table = FALSE
)
}
\arguments{
\item{your_SE}{Your SummarizedExperiment of barcode data and associated metadata}

\item{split_bias_on}{The column in `colData(your_SE)` from which `bias_1` and `bias_2` will be chosen}

\item{bias_1}{The first cell type (or other factor) to be compared. Must be a possible value of the split_bias_on column of your metadata. Will be on the RIGHT side of the histogram.}

\item{bias_2}{The second cell type (or other factor) to be compared. Must be a possible value of the split_bias_on column of your metadata. Will be on the LEFT side of the ridge plot}

\item{split_bias_over}{The column in `colData(your_SE)` that you wish to observe the bias split for. The output will contain a faceted plot: one facet for each value of `split_bias_over` comparing the samples matching `bias_1` and `bias_2` from the `split_bias_on` argument.}

\item{bias_over}{Choice(s) from the column designated in `split_bias_over` that will be used for plotting. Defaults to all.}

\item{remove_unique}{If set to true, only clones present in both samples will be considered.}

\item{breaks}{Numeric. The breaks specified for bins on the x-axis (how biased the clones are towards one factor or the other).}

\item{text_size}{The size of the text in the plot.}

\item{linesize}{The linewidth of the stacked bars which represent individual barcodes}

\item{ncols}{Numeric. Number of columns to plot on using plot_grid from cowplot.}

\item{scale_all_y}{Logical. Whether or not to plot all plots on the same y axis limits.}

\item{return_table}{Logical. If set to TRUE, instead of a plot, tbe function will return a list containing a dataframe for each sample-sample log bias combination containing each barcode sequence and its bias between the samples.}
}
\value{
Histogram of log bias for two factors faceted over another set of factors. Or, if return_table is set to TRUE, a list of dataframes containing the log bias data for each bias comparison passed to the function.
}
\description{
Given a summarized experiment, gives histogram of log biases for 2 cell types. Each stacked bar in the histogram represents a clone binned by log bias defined as the log2 of the percentage abundance in the sample specified in "bias_1" divided by the percentage abundance in "bias_2."
}
\examples{
data(wu_subset)
bias_histogram(
    your_SE = wu_subset, split_bias_on = "celltype",
    bias_1 = "B", bias_2 = "T",
    split_bias_over = "months", ncols = 2
)
}
