% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcode_ggheatmap_stat.R
\name{barcode_ggheatmap_stat}
\alias{barcode_ggheatmap_stat}
\title{Barcode Top Clone Heatmap}
\usage{
barcode_ggheatmap_stat(
  your_SE,
  sample_size,
  stat_test = "chi-squared",
  stat_option = "subsequent",
  reference_sample = NULL,
  stat_display = "top",
  show_all_significant = FALSE,
  p_threshold = 0.05,
  p_adjust = "none",
  bc_threshold = 0,
  plot_labels = NULL,
  n_clones = 10,
  cellnote_assay = "stars",
  your_title = NULL,
  grid = TRUE,
  label_size = 12,
  dendro = FALSE,
  cellnote_size = 4,
  distance_method = "Euclidean",
  minkowski_power = 2,
  hclust_linkage = "complete",
  row_order = "hierarchical",
  clusters = 0,
  percent_scale = c(0, 2.5e-05, 0.001, 0.01, 0.1, 1),
  color_scale = c("#4575B4", "#4575B4", "lightblue", "#fefeb9", "#D73027", "red4"),
  return_table = FALSE
)
}
\arguments{
\item{your_SE}{A Summarized Experiment object.}

\item{sample_size}{A numeric vector providing the sample size of each column of the SummarizedExperiment passed to the function. This sample size describes the samples that the barcoding data is meant to approximate.}

\item{stat_test}{The statistical test to use on the constructed contingency table for each barcoe. Options are "chi-squared" and "fisher."}

\item{stat_option}{For "subsequent" statistical testing is performed on each column of data compared to the column before it. For "reference," all other columns of data are compared to a reference column.}

\item{reference_sample}{Provide the column name of the reference column if stat_option is set to "reference." Defaults to the first column in the SummarizedExperiment.}

\item{stat_display}{Choose which clones to display on the heatmap. IF set to "top," the top n_clones ranked by abundance for each sample will be displayed. If set to "change," the top n_clones with the lowest p-value from statistical testing will be shown for each sample. If set to "increase," the top n_clones (ranked by p-value) which increase in abundance for each sample will be shown. And if set to "decrease," the top n_clones (ranked by lowest p-value) which decrease in abdundance will be shown.}

\item{show_all_significant}{Logical. If set to TRUE when stat_display = "change," "increase," or "decrease" then the n_clones argument will be overriden and all clones with a statistically singificant change, increase, or decrease in proportion will be shown.}

\item{p_threshold}{The p_value threshold to use for statistical testing}

\item{p_adjust}{Character, default = "none". To correct p-values for muiltiple comparisons, set to any of the p value adjustment methods in the p.adjust function in R stats, which includes "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", and "fdr".}

\item{bc_threshold}{Clones must be above this proportion in at least one sample to be included in statistical testing.}

\item{plot_labels}{Vector of x axis labels. Defaults to colnames(your_SE).}

\item{n_clones}{The top 'n' clones to plot.}

\item{cellnote_assay}{Character. One of "stars", "reads", "proportions" or "p_val"}

\item{your_title}{The title for the plot.}

\item{grid}{Logical. Include a grid or not in the heatmap.}

\item{label_size}{The size of the column labels.}

\item{dendro}{Logical. Whether or not to show row dendrogram when hierarchical clustering.}

\item{cellnote_size}{The numerical size of the cell note labels.}

\item{distance_method}{Character. Use summary(proxy::pr_DB) to see all possible options for distance metrics in clustering.}

\item{minkowski_power}{The power of the Minkowski distance (if minkowski is the distance method used).}

\item{hclust_linkage}{Character. One of "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{row_order}{Character; "hierarchical" to perform hierarchical clustering on the output and order in that manner, "emergence" to organize rows  by order of presence in data (from left to right), or a character vector of rows within the summarized experiment to plot.}

\item{clusters}{How many clusters to cut hierarchical tree into for display when row_order is "hierarchical".}

\item{percent_scale}{A numeric vector through which to spread the color scale (values inclusive from 0 to 1). Must be same length as color_scale.}

\item{color_scale}{A character vector which indicates the colors of the color scale. Must be same length as percent_scale.}

\item{return_table}{Logical. Whether or not to return table of barcode sequences with their log abundance in the 'value' column and cellnote (* indicating statistical signficant change, for example) for each sample instead of displaying a plot. Note, for more in-depth statistical analysis, use the `"barcode_stat_test` function.}
}
\value{
Displays a heatmap in the current plot window. Or if return_table is set to TRUE, returns a dataframe of the barcode sequences, log abundances, and cellnote for each sample.
}
\description{
Creates a heatmap from the columns of data in the Summarized Experiment object, with the option to label based on statistical analysis. Uses ggplot2.
}
\examples{
data(wu_subset)
barcode_ggheatmap_stat(
    your_SE = wu_subset[, 1:4], sample_size = rep(5000, 4),
    stat_test = "chi-squared", stat_option = "subsequent",
    p_threshold = 0.05, n_clones = 10,
    cellnote_assay = "stars", bc_threshold = 0.005
)
}
