% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcode_ggheatmap.R
\name{barcode_ggheatmap}
\alias{barcode_ggheatmap}
\title{barcode_ggheatmap}
\usage{
barcode_ggheatmap(
  your_SE,
  plot_labels = NULL,
  n_clones = 10,
  cellnote_assay = "stars",
  your_title = NULL,
  grid = TRUE,
  label_size = 12,
  dendro = FALSE,
  cellnote_size = 4,
  distance_method = "Euclidean",
  minkowski_power = 2,
  hclust_linkage = "complete",
  row_order = "hierarchical",
  clusters = 0,
  percent_scale = c(0, 2.5e-05, 0.001, 0.01, 0.1, 1),
  color_scale = c("#4575B4", "#4575B4", "lightblue", "#fefeb9", "#D73027", "red4"),
  return_table = FALSE
)
}
\arguments{
\item{your_SE}{A Summarized Experiment object.}

\item{plot_labels}{Vector of x axis labels. Defaults to colnames(your_SE).}

\item{n_clones}{The top 'n' clones to plot.}

\item{cellnote_assay}{Character. One of "stars", "counts", or "proportions." To have no cellnote, set cellnote_size to 0.}

\item{your_title}{The title for the plot.}

\item{grid}{Logical. Include a grid or not in the heatmap.}

\item{label_size}{The size of the column labels.}

\item{dendro}{Logical. Whether or not to show row dendrogram when hierarchical clustering.}

\item{cellnote_size}{The numerical size of the cell note labels. To have no cellnote, set cellnote_size to 0.}

\item{distance_method}{Character. Use summary(proxy::pr_DB) to see all possible options for distance metrics in clustering.}

\item{minkowski_power}{The power of the Minkowski distance (if minkowski is the distance method used).}

\item{hclust_linkage}{Character. One of "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{row_order}{Character; "hierarchical" to perform hierarchical clustering on the output and order in that manner, "emergence" to organize rows  by order of presence in data (from left to right), or a character vector of rows within the summarized experiment to plot.}

\item{clusters}{How many clusters to cut hierarchical tree into for display when row_order is "hierarchical".}

\item{percent_scale}{A numeric vector through which to spread the color scale (values inclusive from 0 to 1). Must be same length as color_scale.}

\item{color_scale}{A character vector which indicates the colors of the color scale. Must be same length as percent_scale.}

\item{return_table}{Logical. Whether or not to return table of barcode sequences with their log abundance in the 'value' column and cellnote for each sample instead of displaying a plot.}
}
\value{
Displays a heatmap in the current plot window. Or if return_table is set to TRUE, returns a dataframe of the barcode sequences, log abundances, and cellnotes for each sample.
}
\description{
Creates a heatmap displaying the log abundance of the top 'n' clones from each sample in the Summarized Experiment object, using ggplot2. Clones are on the y-axis and samples are on the x-axis. The ordering and clustering of clones on the y-axis as well as all aesthetics of the plot can be controlled through the arguments described below.
}
\examples{
data(wu_subset)
barcode_ggheatmap(
    your_SE = wu_subset, n_clones = 10,
    grid = TRUE, label_size = 6
)
}
