% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSamplePairCorrelation.R
\name{plotSamplePairCorrelation}
\alias{plotSamplePairCorrelation}
\title{Plot sample pairwise correlation in a Heatmap}
\usage{
plotSamplePairCorrelation(
  barbieQ,
  sampleOrder = NULL,
  sampleMetadata = NULL,
  sampleGroup = NULL,
  method = "pearson"
)
}
\arguments{
\item{barbieQ}{A \code{barbieQ} object created by the \link{createBarbieQ} function.}

\item{sampleOrder}{A character vector of names of the factors in the
sample conditions provided by \code{barbieQ} or \code{sampleMetadata},
specifying the order in which samples should be arranged.
Defaults to the original order of factors in the sample conditions.}

\item{sampleMetadata}{A \code{matrix}, \code{data.frame} or \code{DataFrame} of sample conditions,
where each factor is represented in a separate column. Defaults to NULL,
in which case sample conditions are inherited from \code{colData(barbieQ)$sampleMetadata}.}

\item{sampleGroup}{A string representing the name of a factor from the
sample conditions passed by \code{barbieQ} or \code{sampleMetadata}, or a vector of
sample conditions, indicating the primary factor to split sample slices.}

\item{method}{A string specifying the correlation method to use.
Defaults to 'pearson'. Options include: 'pearson', 'spearman'.}
}
\value{
A 'Heatmap' S4 object displaying the pairwise correlation between
samples in a Heatmap.
}
\description{
\code{plotSamplePairCorrelation()} visualizes the pairwise correlation of
CPM values across samples in a \code{barbieQ} object,
using a heatmap with a checkerboard-like pattern.
}
\examples{
## sample conditions and color palettes
sampleConditions <- data.frame(
  Treat = factor(rep(c('ctrl', 'drug'), each = 6)),
  Time = rep(rep(seq_len(2), each = 3), 2)
)
conditionColor <- list(
  Treat = c(ctrl = '#999999', drug = '#112233'),
  Time = c('1' = '#778899', '2' = '#998877')
)
## Barcode count data
nbarcodes <- 50
nsamples <- 12
barcodeCount <- abs(matrix(10, nbarcodes, nsamples))
barcodeCount[seq(21, 50), ] <- 0.0001
rownames(barcodeCount) <- paste0('Barcode', seq_len(nbarcodes))
## create a `barbieQ` object
myBarbieQ <- createBarbieQ(barcodeCount, sampleConditions, conditionColor)
plotSamplePairCorrelation(myBarbieQ)
}
