% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarcodeSignif.R
\name{plotBarcodePValue}
\alias{plotBarcodePValue}
\title{Plot Barcodes categorized by significant change using a dot plot}
\usage{
plotBarcodePValue(barbieQ, xAxis = "avgRank")
}
\arguments{
\item{barbieQ}{A \code{barbieQ} object created by the \link{createBarbieQ} function,
updated with Barcode test results by calling the \link{testBarcodeSignif} function.}

\item{xAxis}{A string indicating what to visualise on the x scale of the
dot plot. Options include: 'avgRank', 'totalOcc', 'avgLogCPM',
and 'avgProportion'. Defaults to 'avgRank', representing the average
rank of Barcodes across samples.}
}
\value{
A \code{ggplot} S3 class object displaying the significance level
against other properties of Barcodes in a dot plot.
}
\description{
\code{plotBarcodePValue()} use a dot plot to visualize the significance
level of each Barcode in differential proportion or occurrence,
as determined by the \link{testBarcodeSignif} function.
P.values are plotted against other properties of Barcodes
specified by \code{xAxis}.
}
\examples{
Block <- c(1, 1, 2, 3, 3, 4, 1, 1, 2, 3, 3, 4)
Treat <- factor(rep(c('ctrl', 'drug'), each = 6))
Time <- rep(rep(seq_len(2), each = 3), 2)
nbarcodes <- 50
nsamples <- 12
count <- abs(matrix(rnorm(nbarcodes * nsamples), nbarcodes, nsamples))
rownames(count) <- paste0('Barcode', seq_len(nbarcodes))
barbieQ <- createBarbieQ(count, data.frame(Treat = Treat, Time = Time))
testBB <- testBarcodeSignif(barbieQ, sampleGroup = 'Treat')
plotBarcodePValue(barbieQ = testBB)
}
