% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr-method.R
\name{robustMahalanobis}
\alias{robustMahalanobis}
\alias{reprodScore}
\alias{mrMethod}
\title{robust Mahalanobis distance}
\usage{
robustMahalanobis(delta)

reprodScore(x, y, method = c("pearson"))

mrMethod(objectCond1, objectCond2, method = "2017")
}
\arguments{
\item{delta}{The difference profile to compute the squared mahalanobis distance}

\item{x}{Numeric vector to compute reproducibility score}

\item{y}{Numeric vector to compute reproducibility score}

\item{method}{Correlation method. Default is Pearson}

\item{objectCond1}{A list of \code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}}s where each is an experimental
replicate for the first condition, usually a control}

\item{objectCond2}{A list of \code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}}s where each is an experimental
replicate for the second condition, usually a treatment}
}
\value{
The squared Mahalanobis distance

The R score

The MR score of the Ithzak et al. 2016/2017
}
\description{
These function implement the MR method of Itzhak et al
}
\examples{
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## compute delta matrix
deltaMatrix <- exprs(control[[1]]) - exprs(treatment[[1]])
res <- bandle:::robustMahalanobis(deltaMatrix)
##' @examples 
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## compute delta matrix
deltaMatrix1 <- exprs(control[[1]]) - exprs(treatment[[1]])
deltaMatrix2 <- exprs(control[[2]]) - exprs(treatment[[2]])
mr_score <- bandle:::reprodScore(deltaMatrix1, deltaMatrix2)
library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
mr1 <- mrMethod(objectCond1 = control1, objectCond2 = treatment1)
plot(mr1$Mscore, mr1$Rscore, pch = 21, 
     xlab = "MScore", ylab = "RScore")
}
