% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDynamic.R
\name{sim_dynamic}
\alias{sim_dynamic}
\title{Generate a dynamic spatial proteomics experiment}
\usage{
sim_dynamic(
  object,
  subsample = NULL,
  knn_par = 10L,
  fcol = "markers",
  numRep = 6L,
  method = "wild",
  batch = FALSE,
  frac_perm = FALSE,
  nu = 2,
  numDyn = 20L
)
}
\arguments{
\item{object}{A instance of class \code{MSnSet} from which to generate a spatial
proteomics dataset.}

\item{subsample}{how many proteins to subsample to speed up analysis. Default is NULL.}

\item{knn_par}{the number of nearest neighbours to use in KNN classification to simulate
dataset.
Default is 10}

\item{fcol}{feature column to indicate markers. Default is "markers". Proteins
with unknown localisations must be encoded as "unknown".}

\item{numRep}{The total number of datasets to generate. Default is 6. An
integer must be provided}

\item{method}{The bootstrap method to use to simulate dataset. Default is "wild".
refer to BANDLE paper for more details.}

\item{batch}{Whether or not to include batch effects. Default is FALSE.}

\item{frac_perm}{whether or not to permute the fractions. Default is FALSE}

\item{nu}{parameter to generate residual inflated noise. Default is 2. See BANDLE
paper for more details}

\item{numDyn}{An integer number of protein to simulate dynamic transitions. Default is 20}
}
\value{
returns simulate dynamic lopit datasets and the name of the relocalated protein.
}
\description{
A function to simulate dynamic spatial proteomics data using a bootstrap method
}
\examples{
library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, numRep = 6L, numDyn = 100L)


}
