% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bambu-processReads_scoreReadClasses.R
\name{trainBambu}
\alias{trainBambu}
\title{Function to train a model for use on other data}
\usage{
trainBambu(
  rcFile = NULL,
  min.readCount = 2,
  nrounds = 50,
  NDR.threshold = 0.1,
  verbose = TRUE
)
}
\arguments{
\item{rcFile}{summerized experiment object with read classes/ranges produced from bambu(quant = FALSE, discovery = FALSE) or rcOutdir}

\item{min.readCount}{the minimum number of reads a read class is required to be have to be used for training}

\item{nrounds}{xgboost hyperparameter - the number of decision trees in the final mode}

\item{NDR.threshold}{the effective NDR threshold that bambu will try and match on other samples when using this model}

\item{verbose}{if additional messages should be output
Output - A list containing 6 objects which is passed directly into bambu(opt.discovery=list(defaultModels=trainBambu()))
     transcriptModelME - the model for multi-exon transcripts 
     transcriptModelSE - the model for single-exon transcripts 
     txScoreBaseline - the txScore used for NDR calibration for multi-exon transcripts
     txScoreBaselineSE - [DEPRECATED] the txScore used for NDR calibration for single-exon transcripts
     lmNDR = lmNDR - the linear model of the reletionship between txScore and NDR used to calculate the baseline for multi-exon transcripts
     lmNDR.SE = lmNDR.SE - the linear model of the reletionship between txScore and NDR used to calculate the baseline for single-exon transcripts
     NDR.threshold - the NDR threshold usd to calculate the txScoreBaseline on the lmNDR (baselineFDR)}
}
\value{
It returns a model object to use in \link{bambu}
}
\description{
This function train a model for use on other data
}
\details{
Function to train a model for use on other data
}
