% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/awst.R
\name{awst}
\alias{awst}
\alias{awst,matrix-method}
\alias{awst,SummarizedExperiment-method}
\title{Asymmetric Within-Sample Transformation}
\usage{
\S4method{awst}{matrix}(x, poscount = FALSE, full_quantile = FALSE, sigma0 = 0.075, lambda = 13)

\S4method{awst}{SummarizedExperiment}(
  x,
  poscount = FALSE,
  full_quantile = FALSE,
  sigma0 = 0.075,
  lambda = 13,
  expr_values = "counts",
  name = "awst"
)
}
\arguments{
\item{x}{a matrix of (possibly normalized) RNA-seq read counts or a
`SummarizedExperiment`.}

\item{poscount}{a logical value indicating whether positive counts only
should be used for the standardization step.}

\item{full_quantile}{a logical value indicating whether the data have been
normalized with the full-quantile normalization. In this case,
computations can be sped up.}

\item{sigma0}{a multiplicative constant to be applied to the smoothing
function.}

\item{lambda}{a parameter that controls the growth rate of the smoothing
function.}

\item{expr_values}{integer scalar or string indicating the assay that
contains the matrix to use as input.}

\item{name}{string specifying the name of the assay to be used to store the
results of the transformation.}
}
\value{
if `x` is a matrix, it returns a matrix of transformed values, with
  genes in rows and samples in column. If `x` is a `SummarizedExperiment`, it
  returns a `SummarizedExperiment` with the transformed value in the `name`
  slot.
}
\description{
This function implements the asymmetric within-sample transformation
described in Risso and Pagnotta (2019). The function includes two steps: a
standardization step and a asymmetric winsorization step. See details.
}
\details{
The standardization step is based on a log-normal distribution of
   the high-intensity genes. Optionally, only positive counts can be used in
   this step (this option is especially useful for single-cell data). The
   winsorization step is controlled by two parameters, sigma0 and lambda,
   which control the growth rate of the winsorization function.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: the input is a matrix of (possibly normalized) counts

\item \code{SummarizedExperiment}: the input is a SummarizedExperiment with (possibly
normalized) counts in one of its assays.
}}

\examples{
x <- matrix(data = rpois(100, lambda=5), ncol=10, nrow=10)
awst(x)

}
\references{
Risso and Pagnotta (2019). Within-sample standardization and
   asymmetric winsorization lead to accurate classification of RNA-seq
   expression profiles. Manuscript in preparation.
}
