% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_read_rnaseq.R
\name{.read_rnaseq_bams}
\alias{.read_rnaseq_bams}
\alias{.read_rnaseq_counts}
\alias{read_rnaseq_bams}
\alias{read_rnaseq_counts}
\title{Read rnaseq counts/bams}
\usage{
.read_rnaseq_bams(
  dir,
  paired,
  genome,
  nthreads = detectCores(),
  sfile = NULL,
  by.y = NULL,
  ensdb = NULL,
  verbose = TRUE
)

.read_rnaseq_counts(
  file,
  fid_col = 1,
  sfile = NULL,
  by.y = NULL,
  ensdb = NULL,
  verbose = TRUE
)

read_rnaseq_bams(
  dir,
  paired,
  genome,
  nthreads = detectCores(),
  sfile = NULL,
  by.y = NULL,
  block = NULL,
  formula = as.formula("~ subgroup"),
  min_count = 10,
  pseudo = 0.5,
  ensdb = NULL,
  tpm = FALSE,
  cpm = TRUE,
  log2 = TRUE,
  plot = FALSE,
  label = "feature_id",
  pca = plot,
  pls = plot,
  fit = if (plot) "limma" else NULL,
  voom = cpm,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)

read_rnaseq_counts(
  file,
  fid_col = 1,
  sfile = NULL,
  by.y = NULL,
  formula = as.formula("~ subgroup"),
  block = NULL,
  min_count = 10,
  pseudo = 0.5,
  tpm = FALSE,
  ensdb = NULL,
  cpm = !tpm,
  log2 = TRUE,
  plot = FALSE,
  label = "feature_id",
  pca = plot,
  pls = plot,
  fit = if (plot) "limma" else NULL,
  voom = cpm,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dir}{read_rnaseq_bams: bam/sam dir}

\item{paired}{read_rnaseq_bams: TRUE/FALSE : paired end reads ?}

\item{genome}{read_rnaseq_bams: 'mm10', 'hg38', etc. or GTF file}

\item{nthreads}{read_rnaseq_bams: nthreads used by Rsubread::featureCounts()}

\item{sfile}{sample file}

\item{by.y}{sample file mergeby column}

\item{ensdb}{EnsDb with genesizes : e.g. AnnotationHub::AnnotationHub[['AH64923']]}

\item{verbose}{TRUE or FALSE: message?}

\item{file}{count file}

\item{fid_col}{featureid column (number or string)}

\item{block}{model blockvar: string or NULL}

\item{formula}{model formula}

\item{min_count}{min feature count required in some samples}

\item{pseudo}{pseudocount added to prevent -Inf log2 values}

\item{tpm}{TRUE or FALSE : add tpm to assays ( counts / libsize / genelength ) ?}

\item{cpm}{TRUE or FALSE: add cpm to assays ( counts / effectivelibsize ) ?}

\item{log2}{TRUE or FALSE: log2 transform ?}

\item{plot}{TRUE or FALSE: plot?}

\item{label}{fvar}

\item{pca}{TRUE or FALSE: perform and plot pca?}

\item{pls}{TRUE or FALSE: run pls ?}

\item{fit}{model engine: 'limma', 'lm', 'lme(r)', 'wilcoxon' or NULL}

\item{voom}{model weights to be computed?  TRUE/FALSE}

\item{coefs}{model coefficients          of interest: string vector or NULL}

\item{contrasts}{model coefficient contrasts of interest: string vector or NULL}

\item{palette}{color palette : named string vector}
}
\value{
SummarizedExperiment
}
\description{
Read rnaseq counts/bams
}
\examples{
# read_rnaseq_bams
  if (installed('Rsubread')){
      dir <- download_data('billing16.bam.zip')
      object <- read_rnaseq_bams(dir, paired = TRUE, genome = 'hg38')  
      object <- read_rnaseq_bams(dir, paired = TRUE, genome = 'hg38', plot = TRUE)  
  }
# read_rnaseq_counts
  file <- system.file('extdata/billing19.rnacounts.txt', package = 'autonomics')
  object <- read_rnaseq_counts(file, fit = 'limma', coefs = 'E15-E00')
  object <- read_rnaseq_counts(file, fit = 'limma', coefs = 'E15-E00', voom = FALSE)
  object <- read_rnaseq_counts(file, fit = 'limma', coefs = 'E15-E00', voom = FALSE, cpm = FALSE)
  object <- read_rnaseq_counts(file, fit = 'limma', coefs = 'E15-E00', voom = FALSE, cpm = FALSE, 
                                    log2 = FALSE)
  object <- read_rnaseq_counts(file, plot = TRUE)
    
# read_rnaseq_counts(tpm = TRUE)
  \dontrun{
  ah <- AnnotationHub::AnnotationHub()
  ensdb <- ah[['AH64923']]
  object <- read_rnaseq_counts(file, fit = 'limma', coefs = 'E02-E00', tpm = TRUE, ensdb = ensdb)
  }
}
\author{
Aditya Bhagwat, Shahina Hayat
}
