% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_plot.R
\name{plot_violins}
\alias{plot_violins}
\alias{plot_feature_violins}
\alias{plot_sample_violins}
\alias{plot_subgroup_violins}
\title{Plot sample/feature violins}
\usage{
plot_violins(
  object,
  assay = assayNames(object)[1],
  x,
  fill,
  color = NULL,
  group = NULL,
  facet = NULL,
  nrow = NULL,
  ncol = NULL,
  dir = "h",
  scales = "free",
  labeller = label_value,
  highlight = NULL,
  palette = NULL,
  fixed = list(na.rm = TRUE)
)

plot_feature_violins(
  object,
  assay = assayNames(object)[1],
  x = "feature_id",
  fill = "feature_id",
  color = NULL,
  n = 9,
  facet = NULL,
  nrow = NULL,
  ncol = NULL,
  dir = "h",
  scales = "free",
  labeller = label_value,
  highlight = NULL,
  fixed = list(na.rm = TRUE)
)

plot_sample_violins(
  object,
  assay = assayNames(object)[1],
  x = "sample_id",
  fill = if ("subgroup" \%in\% svars(object)) "subgroup" else "sample_id",
  color = NULL,
  n = 100,
  facet = NULL,
  nrow = NULL,
  ncol = NULL,
  dir = "h",
  scales = "free",
  labeller = label_value,
  highlight = NULL,
  fixed = list(na.rm = TRUE)
)

plot_subgroup_violins(
  object,
  assay = assayNames(object)[1],
  subgroup,
  x = "subgroup",
  fill = "subgroup",
  color = NULL,
  highlight = NULL,
  facet = "feature_id",
  fixed = list(na.rm = TRUE)
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{assay}{string}

\item{x}{svar (string)}

\item{fill}{svar (string)}

\item{color}{svar (string)}

\item{group}{svar (string)}

\item{facet}{svar (character vector)}

\item{nrow}{NULL or number}

\item{ncol}{NULL or number}

\item{dir}{'h' or 'v' : are facets filled horizontally or vertically ?}

\item{scales}{'free', 'free_x', 'free_y', or 'fixed'}

\item{labeller}{label_both or label_value}

\item{highlight}{fvar expressing which feature should be highlighted (string)}

\item{palette}{named color vector (character vector)}

\item{fixed}{fixed aesthetics}

\item{n}{number}

\item{subgroup}{subgroup svar}
}
\value{
ggplot object
}
\description{
Plot sample/feature violins
}
\examples{
# data
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% extract(, order(.$subgroup))
    control_features <- c('biotin','phosphate')
    fdata(object) \%<>\% cbind(control = .$feature_name \%in\% control_features)
# plot
    plot_violins(object[1:12, ], x = 'feature_id', fill = 'feature_id')
    plot_feature_violins(object[1:12, ])
    plot_sample_violins(object[, 1:12],  highlight = 'control')
    plot_subgroup_violins(object[1:4, ], subgroup = 'subgroup')
}
\seealso{
\code{\link{plot_exprs}},
         \code{\link{plot_densities}}
}
