% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_plot.R
\name{plot_subgroup_points}
\alias{plot_subgroup_points}
\title{Plot features}
\usage{
plot_subgroup_points(
  object,
  subgroup = "subgroup",
  block = NULL,
  x = subgroup,
  color = subgroup,
  group = block,
  facet = "feature_id",
  nrow = NULL,
  scales = "free_y",
  ...,
  palette = NULL,
  fixed = list(na.rm = TRUE),
  theme = list(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1))
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{subgroup}{subgroup svar}

\item{block}{block svar}

\item{x}{svar mapped to x}

\item{color}{svar mapped to color}

\item{group}{svar mapped to group}

\item{facet}{svar mapped to facets}

\item{nrow}{number of rows}

\item{scales}{'free_y' etc.}

\item{...}{mapped aesthetics}

\item{palette}{color palette (named character vector)}

\item{fixed}{fixed aesthetics}

\item{theme}{ggplot theme specifications}
}
\value{
ggplot object
}
\description{
Plot features
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file, fit = 'limma')
idx <- order(fdata(object)$`p~t1-t0~limma`)[1:9]
object \%<>\% extract(idx, )
plot_sample_boxplots(  object)
plot_feature_boxplots( object)
plot_sample_boxplots(object, x = 'Time')
plot_subgroup_points(  object, subgroup = 'Time')
plot_subgroup_points(  object, subgroup = 'Time', block = 'Subject')
}
