% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_plot_volcano.R
\name{make_volcano_dt}
\alias{make_volcano_dt}
\title{Create volcano datatable}
\usage{
make_volcano_dt(
  object,
  fit = fits(object)[1],
  coefs = coefs(object, fit = fit)[1],
  shape = "imputed",
  size = NULL,
  alpha = NULL,
  label = if ("gene" \%in\% fvars(object)) "gene" else "feature_id"
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{'limma', 'lme', 'lm', 'wilcoxon'}

\item{coefs}{character vector: coefs for which to plot volcanoes}

\item{shape}{fvar or NULL}

\item{size}{fvar or NULL}

\item{alpha}{fvar or NULL}

\item{label}{fvar or NULL}
}
\value{
data.table
}
\description{
Create volcano datatable
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file, impute = TRUE, fit = 'limma')
make_volcano_dt(object, fit = 'limma', coefs = 'Adult-X30dpt')
}
