% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_assertions.R
\name{is_diann_report}
\alias{is_diann_report}
\alias{assert_diann_report}
\alias{assert_fragpipe_tsv}
\alias{assert_maxquant_proteingroups}
\alias{assert_maxquant_phosphosites}
\alias{assert_compounddiscoverer_output}
\title{Is diann report ?}
\usage{
is_diann_report(x, .xname = get_name_in_parent(x))

assert_diann_report(x, .xname = get_name_in_parent(x))

assert_fragpipe_tsv(x, .xname = get_name_in_parent(x))

assert_maxquant_proteingroups(x, .xname = get_name_in_parent(x))

assert_maxquant_phosphosites(x, .xname = get_name_in_parent(x))

assert_compounddiscoverer_output(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{file}

\item{.xname}{name of x}
}
\description{
Is diann report ?
}
\examples{
file <- NULL;                                                                      is_diann_report(file)
file <- 3;                                                                         is_diann_report(file)
file <- 'blabla.tsv';                                                              is_diann_report(file)
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics'); is_diann_report(file)
file <- system.file('extdata/billing19.phosphosites.txt', package = 'autonomics'); is_diann_report(file)
file <- download_data('multiorganism.combined_protein.tsv');                       is_diann_report(file)
file <- download_data('dilution.report.tsv');                                      is_diann_report(file)
}
