% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_assertions.R
\name{has_multiple_levels}
\alias{has_multiple_levels}
\alias{has_multiple_levels.character}
\alias{has_multiple_levels.factor}
\alias{has_multiple_levels.numeric}
\alias{has_multiple_levels.data.table}
\alias{has_multiple_levels.SummarizedExperiment}
\title{Variable has multiple levels?}
\usage{
has_multiple_levels(x, ...)

\method{has_multiple_levels}{character}(x, .xname = get_name_in_parent(x), ...)

\method{has_multiple_levels}{factor}(x, .xname = get_name_in_parent(x), ...)

\method{has_multiple_levels}{numeric}(x, .xname = get_name_in_parent(x), ...)

\method{has_multiple_levels}{data.table}(
  x,
  y,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y),
  ...
)

\method{has_multiple_levels}{SummarizedExperiment}(
  x,
  y,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y),
  ...
)
}
\arguments{
\item{x}{vector, data.table or SummarizedExperiment}

\item{...}{required for s3 dispatch}

\item{.xname}{string}

\item{y}{string}

\item{.yname}{string}
}
\value{
TRUE or false
}
\description{
Variable has multiple levels?
}
\examples{
# numeric
    a <- numeric();                               has_multiple_levels(a)
    a <- c(1, 1);                                 has_multiple_levels(a)
    a <- c(1, 2);                                 has_multiple_levels(a)
# character
    a <- character();                             has_multiple_levels(a)
    a <- c('A', 'A');                             has_multiple_levels(a)
    a <- c('A', 'B');                             has_multiple_levels(a)
# factor
    a <- factor();                                has_multiple_levels(a)
    a <- factor(c('A', 'A'));                     has_multiple_levels(a)
    a <- factor(c('A', 'B'));                     has_multiple_levels(a)
# data.table
    dt <- data.table(a = factor());               has_multiple_levels(dt, 'b')
    dt <- data.table(a = factor());               has_multiple_levels(dt, 'a')
    dt <- data.table(a = factor());               has_multiple_levels(dt, 'a')
    dt <- data.table(a = factor(c('A', 'A')));    has_multiple_levels(dt, 'a')
    dt <- data.table(a = factor(c('A', 'B')));    has_multiple_levels(dt, 'a')
# sumexp
    object <- matrix(1:9, nrow = 3)
    rownames(object) <- sprintf('f\%d', 1:3)
    colnames(object) <- sprintf('s\%d', 1:3)
    object <- list(exprs = object)
    object \%<>\% SummarizedExperiment::SummarizedExperiment()
    object$subgroup <- c('A', 'A', 'A');          has_multiple_levels(object, 'group')
    object$subgroup <- c('A', 'A', 'A');          has_multiple_levels(object, 'subgroup')
    object$subgroup <- c('A', 'B', 'A');          has_multiple_levels(object, 'subgroup')
}
