% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_read_annotations.R
\name{annotate_maxquant}
\alias{annotate_maxquant}
\title{Annotate maxquant}
\usage{
annotate_maxquant(
  dt,
  uniprothdrs,
  contaminanthdrs,
  maxquanthdrs,
  restapi = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dt}{\code{data.table} : output of \code{read_maxquant_(proteingroups|phosphosites)}}

\item{uniprothdrs}{\code{data.table} : output of \code{read_uniprotdt}}

\item{contaminanthdrs}{\code{data.table} : output of \code{read_uniprotdt}}

\item{maxquanthdrs}{\code{data.table} : output of \code{read_uniprotdt}}

\item{restapi}{\code{logical(1)} : use uniprot restapi to complete missing annotations ?}

\item{verbose}{\code{logical(1)} : message ?}
}
\value{
\code{data.table}
}
\description{
Annotate maxquant data.table
}
\details{
Uncollapse, annotate, curate, recollapse, name
}
\examples{
# Fukuda 2020: contaminants + maxquanthdrs
#-----------------------------------------
          file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
            dt <- .read_maxquant_proteingroups(file)
            dt[, 1:2]
     uniprothdrs <- NULL
 contaminanthdrs <- read_contaminantdt()
    maxquanthdrs <- parse_maxquant_hdrs(dt$`Fasta headers`); dt$`Fasta headers` <- NULL
          dt \%<>\% annotate_maxquant(uniprothdrs, contaminanthdrs, maxquanthdrs)
          dt[                 , 1:9]
          dt[    reverse== '+', 1:9]
          dt[contaminant== '+', 1:9]
                                              
# Billing 2019: uniprothdrs + contaminants + maxquanthdrs
#--------------------------------------------------------
profile <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
fosfile <- system.file('extdata/billing19.phosphosites.txt',  package = 'autonomics')
 upfile <- system.file('extdata/uniprot_hsa_20140515.fasta',  package = 'autonomics')
prodt <- .read_maxquant_proteingroups(profile);         prodt[, 1:2]
fosdt <- .read_maxquant_phosphosites(fosfile, profile); fosdt[, 1:3]
    uniprothdrs <- read_uniprotdt(upfile)
contaminanthdrs <- read_contaminantdt()
   maxquanthdrs <- parse_maxquant_hdrs(prodt$`Fasta headers`)
annotate_maxquant(prodt, uniprothdrs, contaminanthdrs, maxquanthdrs)[, 1:8]
annotate_maxquant(fosdt, uniprothdrs, contaminanthdrs, maxquanthdrs)[, 1:8]
}
