% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25_linmod_limma.R, R/26_linmod_lmx.R,
%   R/27_linmod_wilcoxon.R
\name{LINMOD}
\alias{LINMOD}
\alias{linmod_limma}
\alias{fit_limma}
\alias{linmod_lm}
\alias{fit_lm}
\alias{linmod_lme}
\alias{fit_lme}
\alias{linmod_lmer}
\alias{fit_lmer}
\alias{linmod_wilcoxon}
\alias{fit_wilcoxon}
\title{General Linear Model}
\usage{
LINMOD(
  object,
  formula = as.formula("~ subgroup"),
  engine = "limma",
  drop = varlevels_dont_clash(object, all.vars(formula)),
  coding = "code_control",
  design = create_design(object, formula = formula, drop = drop, coding = coding, verbose
    = FALSE),
  block = NULL,
  coefs = contrast_coefs(object, design = design),
  contrasts = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  suffix = paste0("~", engine),
  verbose = TRUE,
  outdir = NULL,
  writefun = "write_xl",
  plotvolcano = FALSE,
  plotexprs = FALSE,
  argsvolcano = list(),
  argsexprs = list(),
  ...
)

linmod_limma(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  coding = "code_control",
  design = create_design(object, formula = formula, drop = drop, coding = coding, verbose
    = FALSE),
  contrasts = NULL,
  coefs = if (is.null(contrasts)) contrast_coefs(design = design) else NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  reset = TRUE,
  suffix = "~limma",
  verbose = TRUE
)

fit_limma(...)

linmod_lm(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  coding = "code_control",
  design = NULL,
  block = NULL,
  coefs = contrast_coefs(object, formula = formula, coding = coding, drop = drop),
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  reset = TRUE,
  suffix = "~lm",
  contrasts = NULL,
  verbose = TRUE
)

fit_lm(...)

linmod_lme(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  coding = "code_control",
  design = NULL,
  block = NULL,
  coefs = contrast_coefs(object, formula = formula, coding = coding, drop = drop),
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  reset = TRUE,
  opt = "optim",
  suffix = "~lme",
  contrasts = NULL,
  verbose = TRUE
)

fit_lme(...)

linmod_lmer(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  coding = "code_control",
  design = NULL,
  block = NULL,
  coefs = contrast_coefs(object, formula = formula, coding = coding, drop = drop),
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  reset = TRUE,
  suffix = "~lmer",
  contrasts = NULL,
  verbose = TRUE
)

fit_lmer(...)

linmod_wilcoxon(
  object,
  formula = as.formula("~ subgroup"),
  drop = NULL,
  coding = "code_control",
  design = NULL,
  block = NULL,
  coefs = NULL,
  contrasts = NULL,
  weightvar = NULL,
  reset = TRUE,
  suffix = "~wilcoxon",
  verbose = TRUE
)

fit_wilcoxon(...)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{formula}{model formula}

\item{engine}{'limma', 'lm', 'lme', 'lmer', or 'wilcoxon'}

\item{drop}{TRUE or FALSE}

\item{coding}{string: codingfunname
\itemize{
    \item 'contr.treatment':          intercept = y0,     coefi = yi - y0
    \item 'contr.treatment.explicit': intercept = y0,     coefi = yi - y0
    \item 'code_control':             intercept = ymean,  coefi = yi - y0
    \item 'contr.diff':               intercept = y0,     coefi = yi - y(i-1)
    \item 'code_diff':                intercept = ymean,  coefi = yi - y(i-1)
    \item 'code_diff_forward':        intercept = ymean,  coefi = yi - y(i+)
    \item 'code_deviation':           intercept = ymean,  coefi = yi - ymean (drop last)
    \item 'code_deviation_first':     intercept = ymean,  coefi = yi - ymean (drop first)
    \item 'code_helmert':             intercept = ymean,  coefi = yi - mean(y0:(yi-1))
    \item 'code_helmert_forward':     intercept = ymean,  coefi = yi - mean(y(i+1):yp)
}}

\item{design}{design matrix}

\item{block}{block svar. Formated as string ('Subject') - all engines), list(Subject = ~ 1) -lme, or formula () ~ (1|Subject)) - lmer.}

\item{coefs}{NULL or character vector: model coefs to record}

\item{contrasts}{NULL or character vector: posthoc contrasts to record}

\item{weightvar}{NULL or name of weight matrix in assays(object)}

\item{suffix}{string: pvar suffix ("limma" in "p~t2~limma")}

\item{verbose}{whether to msg}

\item{outdir}{NULL or dir}

\item{writefun}{'write_xl' or 'write_ods'}

\item{plotvolcano}{TRUE or FALSE}

\item{plotexprs}{TRUE or FALSE}

\item{argsvolcano}{list: volcano args}

\item{argsexprs}{list:  expr   args}

\item{...}{used for s3 dispatch}

\item{reset}{TRUE/FALSE whether to wipe earlier modeling results}

\item{opt}{lme options}
}
\value{
Updated SummarizedExperiment
}
\description{
General Linear Model
}
\examples{
# Standard usage
  file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
  object <- read_metabolon(file)
  LINMOD(object)                                # Default
  LINMOD(object, ~subgroup )                    # Custom formula
  LINMOD(object, ~subgroup, block = 'Subject')  # Block effect
  
# Alternative engines: argument 'engine' or dedicated function
  linmod_limma(   object, ~subgroup, block =     'Subject'     )  # Default engine
  linmod_lm(      object, ~subgroup, block =     'Subject'     )  # Traditional
  linmod_lme(     object, ~subgroup, block =     'Subject'     )  # Powerful random effects
  linmod_lme(     object, ~subgroup, block = list(Subject = ~1))  #     using lme formula
  linmod_lmer(    object, ~subgroup, block =     'Subject'     )  # Yet more powerful random effects
  linmod_lmer(    object, ~subgroup, block =  ~ (1|Subject)    )  #     using lmer formula
  linmod_wilcoxon(object, ~subgroup, block =     'Subject'     )  # Non-parametric
    
# Alternative coding: backward diffs instead of baseline
  linmod_limma(object, ~ subgroup, block = 'Subject', coding = 'code_diff')
  linmod_lme(  object, ~ subgroup, block = 'Subject', coding = 'code_diff')
  linmod_lmer( object, ~ subgroup, block = 'Subject', coding = 'code_diff')
    
# Posthoc contrasts: limma-only, flexible, but sometimes approximate
  linmod_limma(object,     ~ subgroup, block = 'Subject', coding = 'code_control')
  linmod_limma(object, ~ 0 + subgroup, block = 'Subject', contrasts = 't1-t0')
      # flexible, but only approximate
      # stat.ethz.ch/pipermail/bioconductor/2014-February/057682.html
        
# Top-level function also plots and writes
  LINMOD(object, block = 'Subject', coefs = 't1-t0')
  LINMOD(object, block = 'Subject', coefs = 't1-t0', plotvolcano = TRUE)
  LINMOD(object, block = 'Subject', coefs = 't1-t0',   plotexprs = TRUE)
  LINMOD(object, block = 'Subject', coefs = 't1-t0', plotvolcano = TRUE, plotexprs = TRUE)
  LINMOD(object, block = 'Subject', coefs = 't1-t0', plotvolcano = TRUE, plotexprs = TRUE, outdir = tempdir())
}
