% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predSurvCurve.R
\name{predict_SurvCurve}
\alias{predict_SurvCurve}
\title{Predict Survival Curve for a Test Patient Using Cox Model Predictions}
\usage{
predict_SurvCurve(
  cox_pred_training,
  mSurv,
  cox_pred_test,
  eval_surv_times = NULL
)
}
\arguments{
\item{cox_pred_training}{A numeric vector representing the predicted risk 
scores (or log-risk scores) from the Cox model for the training set. It can 
be obtained from *predict_PatientRisk* function.}

\item{mSurv}{A data frame with two columns: "time" representing survival 
times, and "status" representing the event status (1 for event, 0 for 
censored) for the training dataset.}

\item{cox_pred_test}{A numeric vector of length 1 representing the predicted 
risk score (or log-risk score) for the test patient. It can be obtained 
from *predict_PatientRisk* function.}

\item{eval_surv_times}{A numeric vector of times at which the survival curve 
should be evaluated. If NULL (default), the times will be taken from the 
training data up to the maximum event time.}
}
\value{
A list containing:
\itemize{
 \item{\code{eval_times}: The times at which the survival curve is 
                      evaluated.}
 \item{\code{S_0_t}: The baseline survival function evaluated at the times 
                 in \code{eval_surv_times}.}
 \item{\code{S_test_patient}: The survival curve for the test patient at the 
                          times in \code{eval_surv_times}.}
 }
}
\description{
This function computes the survival curve for a test patient based on their 
predicted risk score using a Cox proportional hazards model. It estimates 
the baseline survival function from training data and predicts the survival 
probability for the test patient at specified times.
}
\details{
This function calculates the baseline survival curve using the training data 
by first estimating the hazard function and cumulative hazard function.
Then, it computes the survival probability for the test patient using the 
baseline survival function and the test patient's risk score.
If the test patient's risk is associated with a hazard ratio greater than 1, 
the survival curve will decrease more rapidly. If `eval_surv_times` is 
provided, the curve is evaluated at those specific times; otherwise, the 
function uses the survival times from the training data.
}
\examples{
data(seBRCA)

# prefilterSAM ---
data(ex_prefilterSAM)

# genePheno ---
data(ex_genePheno)

# patientRisk ---
data(ex_patientRisk)

# predictPatientRisk ---
data(ex_predictPatientRisk)

 
#COX prediction for the training set
mPheno <- SummarizedExperiment::colData(seBRCA)
mExprs <- SummarizedExperiment::assay(seBRCA)
geneList <- names(ex_genePheno$genes)

set.seed(5)
mExprSelectedGenes <- mExprs[rownames(mExprs) \%in\% geneList,]

cox_pred_training <- predict_PatientRisk(ex_patientRisk,
                                         mExprSelectedGenes)
cox_pred_training$risk_score
#COX prediction for the test patient
set.seed(5)
cox_pred_test <- predict_PatientRisk(ex_patientRisk,
                                     ex_predictPatientRisk)
cox_pred_test$risk_score
#Survival curve estimation
eval_surv_times <- seq(0, max(mPheno$time), by = 0.1)
set.seed(5)
surv_curv_cox <- predict_SurvCurve(cox_pred_training$risk_score,
                                   mPheno[, c(2, 3)],
                                   cox_pred_test$risk_score,
                                   eval_surv_times)

}
\references{
\itemize{
  \item{\insertRef{martinezromero2018}{asuri}} 
  \item{\insertRef{BuenoFortes2023}{asuri}}
}
}
