% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotKM}
\alias{plotKM}
\title{Plot the KM curves for geneSurv() and patientRisk()}
\usage{
plotKM(
  result,
  col.surv = NULL,
  col.ci = NULL,
  par.bot = 6,
  par.left = 10,
  par.top = 2,
  par.right = 4,
  y.just.legend = 0.5,
  x.title.adj = 1.75,
  mark = 3,
  simple = FALSE,
  xaxis.at = c(0:10),
  xaxis.lab = xaxis.at,
  lty.surv = 1,
  lty.ci = 3,
  lwd = 4,
  lwd.surv = 4,
  lwd.ci = 4,
  group.names = "",
  group.order = seq_along(km$n),
  extra.left.margin = 4,
  label.n.at.risk = FALSE,
  draw.lines = TRUE,
  cex.axis = 1.25,
  main = "",
  xlim = c(0, 10),
  ylim = c(0, 1),
  grid = TRUE,
  lty.grid = 1,
  lwd.grid = 1,
  col.grid = grey(0.9),
  legend = TRUE,
  loc.legend = "bottomleft",
  add = FALSE,
  ...
)
}
\arguments{
\item{result}{Returning object from running genesurv or patientRisk function}

\item{col.surv}{Color for the survival curve lines}

\item{col.ci}{Color for the confidence interval lines}

\item{par.bot}{Bottom margin of the plot}

\item{par.left}{Left margin of the plot}

\item{par.top}{Top margin of the plot}

\item{par.right}{Right margin of the plot}

\item{y.just.legend}{Vertical adjustment for the legend}

\item{x.title.adj}{Horizontal adjustment for the x-axis title}

\item{mark}{Symbol used for censoring marks}

\item{simple}{Logical; if TRUE, use a simplified plot style}

\item{xaxis.at}{Positions of ticks on the x-axis}

\item{xaxis.lab}{Labels for the x-axis ticks}

\item{lty.surv}{Line type for survival curves}

\item{lty.ci}{Line type for confidence intervals}

\item{lwd}{Overall line width}

\item{lwd.surv}{Line width for survival curves}

\item{lwd.ci}{Line width for confidence intervals}

\item{group.names}{Names of groups in the plot}

\item{group.order}{Order of groups to display}

\item{extra.left.margin}{Additional left margin space}

\item{label.n.at.risk}{Logical; whether to label number at risk}

\item{draw.lines}{Logical; whether to draw the survival lines}

\item{cex.axis}{Magnification of axis annotation}

\item{main}{Main title of the plot}

\item{xlim}{Limits of the x-axis}

\item{ylim}{Limits of the y-axis}

\item{grid}{Logical; whether to draw grid lines}

\item{lty.grid}{Line type for grid lines}

\item{lwd.grid}{Line width for grid lines}

\item{col.grid}{Color for the grid lines}

\item{legend}{Logical; whether to include a legend}

\item{loc.legend}{Location of the legend (e.g., "bottomleft")}

\item{add}{Logical; if TRUE, add to an existing plot}

\item{...}{Additional arguments passed to plotting functions}
}
\value{
Plot of Kaplan-Meier for each risk/expression group from 
geneSurv() or patientRisk()
}
\description{
This function is called internally by the patientRisk function to generate 
the Kaplan-Meier curves. It also can be used after the function has been run 
to generate the plots again without running geneSurv() or patientRisk().
}
\examples{

# Genesurv
data(seBRCA)
time <- "time"
status <- "status"
geneName <- "ESR1"
# The TIME value must be transformed to YEARS
# The gene expression vector must be provided with the NAMES of each sample,
# that should match the time and status NAMES.
set.seed(5)
outputKM <- geneSurv(seBRCA, time, status, geneName, type = "exprs")

# Generate the plots again
## Plots for c(type = exprs)
plotKM(outputKM)

# PatientRisk
data(seBRCA)

# genePheno ---
data(ex_genePheno)

# Survival times should be provided in YEARS
time <- 'time'
status <- 'status'
geneList <- names(ex_genePheno$genes)

set.seed(5)
ex_patientRisk <- patientRisk(seBRCA, geneList, time, status, 
                              method = "class.probs", 
                              nboot = 10)

# NOTE: For consistent results with the vignettes and example data, use 
# default parameters (e.g., nboot = 50).

# Generate the plots again
plotKM(ex_patientRisk)

}
\seealso{
\code{\link{geneSurv}} or \code{\link{patientRisk}} for more 
information about the analysis
}
