% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{artms_config}
\alias{artms_config}
\title{artMS configuration template}
\format{
The configuration (\code{yaml}) file contains the following sections:
\describe{
\item{files}{
\itemize{
\item \code{evidence} : /path/to/the/evidence.txt
\item \code{keys} : /path/to/the/keys.txt
\item \code{contrasts} : /path/to/the/contrast.txt
\item \code{summary} : /path/to/the/summary.txt
\item \code{output} : /path/to/the/output/results/results.txt}
}

\item{qc}{
\itemize{
\item basic: 1 # 1 = yes; 0 = no
\item extended: 1 # 1 = yes; 0 = no
\item extendedSummary: 0 # 1 = yes; 0 = no
}
}

\item{data}{
\itemize{
\item enabled : 1 # 1 = yes; 0 = no
\item silac:
\itemize{
\item enabled : 0 # 1 for SILAC experiments
}
\item filters:
\itemize{
\item enabled : 1
}
\item contaminants : 1
\item protein_groups : remove #remove, keep
\item modifications : ab # PH, UB, AB, APMS
\item sample_plots : 1 # correlation plots }
}

\item{msstats}{
\itemize{
\item enabled : 1
\item msstats_input : # blank if not previous msstats input file is available
\item profilePlots : none # before, after, before-after, none
\item normalization_method : equalizeMedians # globalStandards
(include a reference protein(s) ), equalizeMedians, quantile, 0
\item normalization_reference :  #should be a value in the Protein column
\item summaryMethod : TMP # "TMP"(default) means Tukey's median polish,
which is robust estimation method. "linear" uses linear mixed model.
"logOfSum" conducts log2 (sum of intensities) per run.
\item censoredInt : NA  # Missing values are censored or at random. 'NA'
(default) assumes that all 'NA's in 'Intensity' column are censored.
'0' uses zero intensities as censored intensity. In this case,
NA intensities are missing at random. The output from Skyline
should use '0'. Null assumes that all NA intensites are randomly missing.
\item MBimpute : 1 # only for summaryMethod="TMP" and censoredInt='NA' or '0'.
TRUE (default) imputes 'NA' or '0' (depending on censoredInt option) by
Accelated failure model. FALSE uses the values assigned by cutoffCensored
\item For all othe features, please check documentation for MSstats' dataProcess function
}
}

\item{output_extras}{
\itemize{
\item output_extras :
\itemize{
\item enabled : 1 # if 0, it wont do anything in this section
}
\item annotate :
\itemize{
\item enabled: 1 # 1|0 whether to annotate the proteins in the results or not
}
\item species : HUMAN  # Supported species: HUMAN, MOUSE, ANOPHELES, ARABIDOPSIS,
BOVINE, WORM, CANINE, FLY, ZEBRAFISH, ECOLI_STRAIN_K12, ECOLI_STRAIN_SAKAI,
CHICKEN, RHESUS, MALARIA, CHIMP, RAT, YEAST, PIG, XENOPUS
\item plots:
\itemize{
\item volcano: 1
\item heatmap: 1
\item LFC : -1.5 1.5 # Range of minimal log2fc
\item FDR : 0.05
\item heatmap_cluster_cols : 0
\item heatmap_display : log2FC # log2FC or pvalue}
}
}
}
}
\usage{
artms_config
}
\description{
The configuration file in \code{yaml} format contains
the configuration details required to run \code{artmsQuantification()}, which
includes quality control functions
}
\keyword{datasets}
