% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstats_functions.R
\name{artmsMergeEvidenceAndKeys}
\alias{artmsMergeEvidenceAndKeys}
\title{Merge evidence.txt (or summary.txt) with keys.txt files}
\usage{
artmsMergeEvidenceAndKeys(
  x,
  keys,
  by = c("RawFile"),
  isSummary = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{(data.frame or char) The evidence data, either as data.frame or
the file name (and path). It also works for the summary.txt file}

\item{keys}{The keys data, either as a data.frame or file name (and path)}

\item{by}{(vector) specifying the columns use to merge the evidence and keys.
Default: \code{by=c('RawFile')}}

\item{isSummary}{(logical) TRUE or FALSE (default)}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(data.frame) with the evidence and keys merged
}
\description{
Merge the evidence and keys files on the given columns
}
\examples{
evidenceKeys <- artmsMergeEvidenceAndKeys(x = artms_data_ph_evidence,
                                           keys = artms_data_ph_keys)
}
\keyword{evidence,}
\keyword{keys}
\keyword{merge,}
\keyword{summary,}
