% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichments.R
\name{artmsEnrichLog2fc}
\alias{artmsEnrichLog2fc}
\title{Enrichment of changes in protein abundance or PTMs}
\usage{
artmsEnrichLog2fc(
  dataset,
  species,
  background,
  heatmaps = FALSE,
  output_name = "enrichment.txt",
  verbose = TRUE
)
}
\arguments{
\item{dataset}{(data.frame) with a \code{Gene} and \verb{Comparison or Label} (with
the name of the comparisons specified in the contrast file) columns}

\item{species}{(char) Specie, only supported "human" or "mouse"}

\item{background}{(vector) Background genes for the enrichment analysis.}

\item{heatmaps}{(logical) if \code{TRUE} generates heatmaps (pdf),
\code{FALSE} (default) otherwise.}

\item{output_name}{(char) Name of the annotation files, which will be used
as well for the heatmaps (if \code{heatmaps} is selected)
Default \code{output_name = "enrichment.txt"}}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(data.frame) Results from the enrichment analysis using Gprofiler
and heatmaps (if selected)
}
\description{
Enrichment analysis of the selected proteins
}
\examples{
\dontrun{
# The data must be annotated (Protein and Gene columns)
data_annotated <- artmsAnnotationUniprot(
                      x = artms_data_ph_msstats_results,
                      columnid = "Protein",
                      species = "human")
# And then the enrichment
enrich_set <- artmsEnrichLog2fc(
                   dataset = data_annotated,
                   species = "human",
                   background = unique(data_annotated$Gene))
}
}
\keyword{enrichment}
