% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_intensity_RT.R
\name{artmsAvgIntensityRT}
\alias{artmsAvgIntensityRT}
\title{Summarize average intensity and retention time per protein}
\usage{
artmsAvgIntensityRT(
  evidence_file,
  protein_file = NULL,
  output_file = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{evidence_file}{(char) The filepath to the MaxQuant searched data
(evidence) file (txt tab delimited file).}

\item{protein_file}{(char) The file path to a file or vector containing
a list of proteins of interest.}

\item{output_file}{(char) The file name for the results
(must have the extension \code{.txt}). If empty, then the
results will be returned as an R object.}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
An R object with the results and a file with the results (if the
output_file argument is provided). It contains averages of Intensity,
Retention Time, Caliberated Retention Time
}
\description{
Input an evidence file from MaxQuant and a file
containing a list of proteins of interest (optional).
The function will summarize from the evidence file and report back the
average intensity, average retention time, and the average caliberated
retention time. If a list of proteins is provided, then only those proteins
will be summarized and returned.
}
\examples{
ave_int <- artmsAvgIntensityRT(evidence_file = artms_data_ph_evidence)
}
\keyword{MaxQuant,}
\keyword{caliberated}
\keyword{evidence,}
\keyword{intensity,}
\keyword{retention}
\keyword{summary,}
\keyword{time,}
