% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysisQuantifications.R
\name{artmsAnnotateSpecie}
\alias{artmsAnnotateSpecie}
\title{Adding a column with the species name}
\usage{
artmsAnnotateSpecie(df, pathogen = "nopathogen", species)
}
\arguments{
\item{df}{(data.frame) with a \code{Protein} column (of uniprot ids)}

\item{pathogen}{(char) Is there a pathogen in the dataset as well?
if it does not, then use \code{pathogen = nopathogen} (default). Supported\code{tb}
(Tuberculosis),
\code{lpn} (Legionella)}

\item{species}{(char) Host organism (supported for now: \code{human} or \code{mouse})}
}
\value{
(data.frame) The same data.frame but with an extra column
specifying the species
}
\description{
Adding the species name to every protein.
This makes more sense if there are more than one species in the dataset,
which must be specified in the \code{pathogen} option. Influenza is a special
case that it does not need to be specified, as far as the proteins were
originally annotated as \code{INFLUENZAGENE_STRAIN}
(strains covered \code{H1N1}, \code{H3N2}, \code{H5N1}), as for example, \code{NS1_H1N1}
}
\examples{
# Adding a new column with the main species of the data. Easy.
# But the main functionality is to add both the host-species and a pathogen,
# which is not illustrated in this example
data_with_specie <- artmsAnnotateSpecie(df = artms_data_ph_msstats_results,
                                         species = "human")
}
\keyword{annotation,}
\keyword{species}
