% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLikes.R
\name{logLikNB}
\alias{logLikNB}
\title{Log likelihood for Negative Binomial}
\usage{
logLikNB(y, x, beta, param, offset)
}
\arguments{
\item{y}{the counts}

\item{x}{a design matrix}

\item{beta}{the coefficient vector (natural log scale)}

\item{param}{the overdispersion (alpha in DESeq2 notation)}

\item{offset}{an offset matrix (natural log scale)}
}
\value{
the log likelihood for each sample in \code{y}
}
\description{
This is a simple function to be passed to \code{apeglm}
as a log likelihood for the negative binomial distribution.
}
\examples{

# this function is used by 'apeglm' to specify
# a negative binomial log likelihood.
# so it's only passed as an argument, not for use on its own.
# we can show its output nevertheless:

y <- rnbinom(10, mu=100, size=1/.1)
x <- cbind(rep(1,10),rep(0:1,each=5))
beta <- c(log(100),0)
param <- .1
offset <- rep(0, 10)
logLikNB(y, x, beta, param, offset)

}
