% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqRun.R
\name{anota2seqRun}
\alias{anota2seqRun}
\title{Wrapper for several functions which provide one-step analysis}
\usage{
anota2seqRun(Anota2seqDataSet, contrasts = NULL, performQC = TRUE,
  onlyGroup = FALSE, performROT = TRUE, generateSingleGenePlots = FALSE,
  analyzeBuffering = TRUE, analyzemRNA = TRUE, thresholds = NULL,
  useRVM = TRUE, correctionMethod = "BH", useProgBar = TRUE)
}
\arguments{
\item{Anota2seqDataSet}{Object of class Anota2seqDataSet}

\item{contrasts}{If NULL (default), the contrasts will be created 
automatically and may not correspond to those of interest. It is 
therefore possible to use custom contrasts using this parameter. The 
input should be a matrix with row names corresponding to treatments 
(i.e. those in phenoVec or the treatment column of the 
SummarizedExperiment annotation) and columns corresponding to the 
different contrasts of interest (additional details on how to set up 
the contrast matrix is indicated in details section).}

\item{performQC}{Boolean that defaults to TRUE. Used to specify if the 
anota2seqPerformQC function should be run.}

\item{onlyGroup}{Boolean parameter of the anota2seqPerformQC function 
(default: FALSE). In anota2seqPerformQC, it is possible to suppress the
omnibus interaction analysis and only perform the omnibus treatment 
analysis. Typically, when the data contains less than 3 samples in each
sample class and more than 2 sample classes, the interaction analysis 
cannot be performed but the onlyGroup mode (i.e. with onlyGroup = TRUE)
can be used to assess omnibus group effects.}

\item{performROT}{Boolean that defaults to TRUE. Used to specify if the 
anota2seqResidOutlierTest function should be run.}

\item{generateSingleGenePlots}{Should the single gene graphical outputs 
from the anota2seqPerformQC and anota2seqResidOulierTest functions be 
generated. Default is set to FALSE.}

\item{analyzeBuffering}{Boolean that defaults to TRUE. Used to specify if
changes in translational efficiency leading to buffering should be be 
analyzed.}

\item{analyzemRNA}{Boolean that defaults to TRUE. Used to specify if 
translated mRNA (e.g. polysome-associated mRNA or RPFs) and total mRNA 
should be analyzed.}

\item{thresholds}{A list containing thresholds that are applied during filtering 
of several parameters as described for the anota2seqSelSigGenes function. This 
list can contain the following name slots and if different from the below 
default values
will update such defaults: \itemize{ \item minSlopeTranslation: The
output can be filtered so that identifiers whose identified slopes in
analysis of changes in translational efficiency leading to altered
protein levels are too small can be excluded. Default is -1 i.e.
excludes identifiers with a slope <(-1). \item maxSlopeTranslation: The
output can be filtered so that identifiers whose identified slopes in
analysis of changes in translational efficiency leading to altered
protein levels are too large can be excluded. Default is 2 i.e.
excludes identifiers with a slope > 2. \item minSlopeBuffering: The
output can be filtered so that identifiers whose identified slopes in
analysis of changes in translational efficiency leading to buffering
are too small can be excluded. Default is -2 i.e. excludes identifiers
with a slope <(-2). \item maxSlopeBuffering: The output can be filtered
so that genes whose identified slopes in analysis of changes in
translational efficiency leading to buffering are too large can be
excluded. Default is 1 i.e. excludes identifiers with a slope > 1. 
\item maxPAdj: The output can be filtered based on adjusted p-values
from the anota2seq analysis (i.e. smaller compared to assigned value).
If useRVM is set to TRUE, filtering will be performed on RVM values,
otherwise filtering will be performed on non-RVM values. Multiple
testing adjustment method is set by argument correctionMethod. Default
is 0.15. \item maxP: The output can be filtered based on unadjusted
p-values from the anota2seq analysis (i.e. smaller compared to assigned
value). If useRVM is set to TRUE, filtering will be performed on RVM
values, otherwise filtering will be performed on non-RVM values.
Default is NULL, i.e. no filtering. \item minEff: The output can be
filtered based on minimum effect for inclusion. The value is applied
both to negative and positive effects: e.g. a value of 1 will evaluate
if the effects are >1 OR <(-1). Default is NULL i.e. no filtering based
on effect. \item deltaPT: The output can be filtered based on the mean
log2(translated mRNA data [e.g. polysome-associated mRNA or RPFs] /
total mRNA data) difference between treatments. The treatments are
defined by the selected contrast. Default is log2(1.2). Only applied when
analysis is set to "translation". \item deltaTP:
The output can be filtered based on the mean log2(total mRNA / 
translated mRNA data [e.g. polysome-associated mRNA or RPFs]) 
difference between treatments. The treatments are defined by the 
selected contrast. Default is log2(1.2). Only applied when analysis
is set to "buffering". \item deltaP: The output can
be filtered based on a minimum effect between the treatment and
control groups in polysome-associated mRNA. Default is NULL (i.e. no
filtering). Use when analysis 
parameter is set to "translation" (i.e. changes in translational 
efficiency leading to altered protein levels) or "translated mRNA" 
\item deltaT: The output
can be filtered based on a minimum effect between the treatment
and control groups in total mRNA. Default is NULL (i.e. no filtering).
Use when analysis parameter is set to "buffering" or "total mRNA".}}

\item{useRVM}{Should the Random Variance Model be applied. Default is 
TRUE.}

\item{correctionMethod}{Correction for multiple testing method. This 
parameter can be set to "Bonferroni", "Holm", "Hochberg", "SidakSS", 
"SidakSD", "BH", "BY", "ABH" or "TSBH" as implemented in the multtest 
package or "qvalue" as implemented in the qvalue package. Default is 
"BH".}

\item{useProgBar}{Should the progress bar be shown. Default is TRUE, show
progress bar.}
}
\value{
An Anota2seqDataSet containing normalized data, model covariates 
  and contrasts as well as outputs of all functions called by 
  \code{anota2seqRun}. anota2seqRun will also output all diagnostic plots
  provided by \code{\link{anota2seqPerformQC}}, 
  \code{\link{anota2seqResidOutlierTest}} and 
  \code{\link{anota2seqAnalyze}}.
}
\description{
anota2seqRun is a wrapper function running the following 
  steps of the anota2seq workflow: assessing model assumptions (by 
  calling \code{\link{anota2seqPerformQC}} and 
  \code{\link{anota2seqResidOutlierTest}}), performing analysis of 
  changes in translational efficiency leading to altered protein levels 
  or buffering; and differential expression of translated mRNA (e.g. 
  polysome-associated mRNA or RPF) and total mRNA (by calling 
  \code{\link{anota2seqAnalyze}} sequentially with analysis parameter set
  to "translation", "buffering", "translated mRNA", "total mRNA" 
  respectively). Gene filtering is performed by calling 
  \code{\link{anota2seqSelSigGenes}} and \code{\link{anota2seqRegModes}} 
  categorizes regulated genes into regulatory modes (mRNA abundance or 
  changes in translational efficiency leading to altered protein levels 
  or buffering).
}
\details{
At the step of analysis, by default (i.e. with contrasts = NULL)
  the order of the sample classes which are used to calculate differences
  between treatments will be in alphabetical order. To change the 
  directionality of the contrasts (e.g. treatment b vs treatment a 
  instead of treatment a vs treatment b) or to generate a custom set of 
  contrasts when more than 2 treatments are included, a contrast matrix 
  can be supplied to the "contrasts" parameter described above. The row 
  names should be specified as indicated above. The contrasts are coded 
  by using e.g. -1 for group a, 0 for group b and 1 for group c to 
  compare group a and c; -2 for group a, 1 for group b and 1 for group c 
  to compare group a to b & c. Each column of the contrast matrix should 
  sum to 0 and to analyze orthagonal contrasts the products of all 
  pairwise rows should sum to 0. The results in the 
  Anota2seqDataSet object will follow the order of the contrasts (i.e. 
  results for e.g. contrast 1 will correspond to the contrasts specified 
  in column 1 of the contrast matrix).
}
\examples{
data(anota2seq_data)
# Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Perform anota2seqRun function
# The quality control and residual outlier testing are not 
# performed in order to limit the running time of this example, but the model 
# assumptions should be assessed (see help of anota2seqPerformQC)
Anota2seqDataSet <- anota2seqRun(Anota2seqDataSet,
    performQC = FALSE, 
    performROT = FALSE, 
    useProgBar = FALSE)
    
\dontrun{    
# Example to build a custom contrast matrix
# For the purpose of this example, we will use the first 6 samples of the 
# simulated data provided with the package together with the following "dummy"
# sample classes:
phenoVec <- c("a","a","b","b","c","c")
contrastsEx_ads <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:300, 1:6],
    dataT = anota2seq_data_T[1:300, 1:6],
    phenoVec = phenoVec,
    dataType = "RNAseq",
    normalize = TRUE)

# Get the levels of the phenoVec, these will be ordered as in anota2seq
phenoLev <- levels(as.factor(phenoVec))
# Construct the matrix with appropriate nrow and ncol
myContrast <- matrix(nrow =length(phenoLev),ncol=length(phenoLev)-1)
# Set the phenoLev as rownames for your contrast matrix
rownames(myContrast) <- phenoLev
# Now indicate the contrasts you want to analyse as explained above
# Compare a to c
myContrast[,1] <- c(-1,0,1)
# Compare a to b& c
myContrast[,2] <- c(2,-1,-1)
myContrast
#   [,1] [,2]
# a   -1    2
# b    0   -1
# c    1   -1
# The custom contrast matrix can then be used as input of anota2seqRun. Because 
# these data have only 2 samples per sample class, the onlyGroup mode of 
# anota2seqPerformQC is the only available mode for assessment of model 
# assumptions so we also set onlyGroup to TRUE.
contrastsEx_ads <- anota2seqRun(contrastsEx_ads,
                                contrasts = myContrast, 
                                performQC = FALSE, 
                                performROT = FALSE,
                                onlyGroup = TRUE,
                                thresholds = list(
                                    maxPAdj = 0.25,
                                    deltaPT = log2(2))) 
                                    }

}
\seealso{
\code{\link{anota2seqPerformQC}}, 
  \code{\link{anota2seqResidOutlierTest}}, 
  \code{\link{anota2seqAnalyze}}, \code{\link{anota2seqSelSigGenes}} 
  \code{\link{anota2seqRegModes}}
}
