% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetContrasts}
\alias{anota2seqGetContrasts}
\alias{anota2seqGetContrasts,Anota2seqDataSet-method}
\title{Accessor for the 'contrasts' slot of an Anota2seqDataSet object.}
\usage{
anota2seqGetContrasts(object)

\S4method{anota2seqGetContrasts}{Anota2seqDataSet}(object)
}
\arguments{
\item{object}{A Anota2seqDataSet.}
}
\value{
A matrix containing information about the analyzed contrasts to be 
  used for the analysis.
}
\description{
Retrieve from an Anota2seqDataSet the contrast matrix that is used in the
analysis
}
\examples{
data(anota2seq_data)
# Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Run analysis of differential translation
Anota2seqDataSet <- anota2seqAnalyze(Anota2seqDataSet, 
                                     analysis = "translation")
contr <- anota2seqGetContrasts(Anota2seqDataSet)
contr
#           treatment
# ctrl             -1
# treatment         1
}
\seealso{
\code{\link{Anota2seqDataSet-class}}
}
