% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InMemoryAnnData.R
\name{as_InMemoryAnnData}
\alias{as_InMemoryAnnData}
\title{Convert an \code{AnnData} to an \code{InMemoryAnnData}}
\usage{
as_InMemoryAnnData(adata)
}
\arguments{
\item{adata}{An \code{AnnData} object to be converted to \code{\link{InMemoryAnnData}}}
}
\value{
An \code{\link{InMemoryAnnData}} object with the same data as the input
\code{AnnData} object
}
\description{
Convert another \code{AnnData} object to an \code{\link{InMemoryAnnData}} object
}
\examples{
ad <- AnnData(
  X = matrix(1:5, 3L, 5L),
  layers = list(
    A = matrix(5:1, 3L, 5L),
    B = matrix(letters[1:5], 3L, 5L)
  ),
  obs = data.frame(row.names = LETTERS[1:3], cell = 1:3),
  var = data.frame(row.names = letters[1:5], gene = 1:5)
)
ad$as_InMemoryAnnData()
}
\seealso{
Other object converters: 
\code{\link{as_AnnData}()},
\code{\link{as_HDF5AnnData}()},
\code{\link{as_ReticulateAnnData}()},
\code{\link{as_Seurat}()},
\code{\link{as_SingleCellExperiment}()},
\code{\link{reticulate-helpers}}
}
\concept{object converters}
\keyword{internal}
