% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnData.R
\name{AnnData}
\alias{AnnData}
\title{Create an in-memory AnnData object.}
\usage{
AnnData(
  X = NULL,
  obs = NULL,
  var = NULL,
  layers = NULL,
  obsm = NULL,
  varm = NULL,
  obsp = NULL,
  varp = NULL,
  uns = NULL,
  shape = NULL
)
}
\arguments{
\item{X}{See the \code{X} slot in \link{AnnData-usage}}

\item{obs}{See the \code{obs} slot in \link{AnnData-usage}}

\item{var}{See the \code{var} slot in \link{AnnData-usage}}

\item{layers}{See the \code{layers} slot in \link{AnnData-usage}}

\item{obsm}{See the \code{obsm} slot in \link{AnnData-usage}}

\item{varm}{See the \code{varm} slot in \link{AnnData-usage}}

\item{obsp}{See the \code{obsp} slot in \link{AnnData-usage}}

\item{varp}{See the \code{varp} slot in \link{AnnData-usage}}

\item{uns}{See the \code{uns} slot in \link{AnnData-usage}}

\item{shape}{Shape tuple (e.g. \code{c(n_obs, n_vars)}). Can be provided if both
\code{X} or \code{obs} and \code{var} are not provided.}
}
\value{
An \link{InMemoryAnnData} object
}
\description{
For more information on the functionality of an AnnData object, see \link{AnnData-usage}
}
\examples{
adata <- AnnData(
  X = matrix(1:12, nrow = 3, ncol = 4),
  obs = data.frame(
    row.names = paste0("obs", 1:3),
    n_counts = c(1, 2, 3),
    n_cells = c(1, 2, 3)
  ),
  var = data.frame(
    row.names = paste0("var", 1:4),
    n_cells = c(1, 2, 3, 4)
  )
)

adata
}
\seealso{
\link{AnnData-usage} for details of \code{AnnData} structure and usage

Other AnnData creators: 
\code{\link{as_AnnData}()},
\code{\link{read_h5ad}()}
}
\concept{AnnData creators}
