% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mae_pick_organisms}
\alias{mae_pick_organisms}
\title{Modify organisms of multi-assay experiment object}
\usage{
mae_pick_organisms(MAE, isolate_organisms = NULL, discard_organisms = NULL)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{isolate_organisms}{Isolate specific organisms e.g. ti|001, ti|002}

\item{discard_organisms}{Discard specific organisms e.g. ti|001, ti|002}
}
\value{
A multi-assay experiment object
}
\description{
Modify organisms of multi-assay experiment object
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
subset <- mae_pick_organisms(toy_data,
  isolate_organisms = c("ti|001", "ti|002")
)

}
