% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_angles.R
\name{factorise}
\alias{factorise}
\title{Factorize Angle Matrices into Z-Scores}
\usage{
factorise(
  x_mat,
  method = "cosine",
  seed = 1,
  permute_row_or_column = "column",
  permutation_function = "sample",
  normalization_method = "divide_by_total_counts"
)
}
\arguments{
\item{x_mat}{A \code{\link[bigstatsr]{FBM}} object representing the
normalized and scaled gene expression matrix.}

\item{method}{A character string specifying the method for calculating the
relationship between gene pairs. Default is \code{"cosine"}. Other options
include \code{"spearman"}}

\item{seed}{An integer value for setting the seed for reproducibility during
permutation. Default is \code{1}.}

\item{permute_row_or_column}{Character "row" or "column", whether
permutations should be executed row-wise or column wise.
Default is \code{"column"}}

\item{permutation_function}{Character "sample" or "permute_nonzero".
If sample, then sample is used for constructing background distributions.
If permute_nonzero, then only non-zero values are permuted.
Default is \code{"sample"}}

\item{normalization_method}{Character "divide_by_total_counts" or
"scale_by_total_counts". Default is \code{"divide_by_total_counts"}}
}
\value{
An \code{\link[bigstatsr]{FBM}} object containing the
z-score-transformed angle matrix.
}
\description{
\code{factorise} computes the angle matrix of the input gene expression
matrix using the specified method, performs permutation to create a null
distribution, and transforms the correlations into z-scores. This function
is optimized for large datasets using the \pkg{bigstatsr} package.
}
\details{
The function performs the following steps:
\enumerate{
\item \strong{Permutation}: The input matrix is permuted column-wise to disrupt
existing angles, creating a null distribution.
\item \strong{Angle Computation}: Computes the angle matrix for both the
original and permuted matrices using \code{\link{extract_angles}}.
\item \strong{Method-Specific Processing}:
\itemize{
\item For other methods (\code{"cosine"}, \code{"spearman"}),
statistical measures are computed from the permuted data.
}
\item \strong{Statistical Measures}: Calculates mean, variance, and standard
deviation using \code{\link{get_dstat}}.
\item \strong{Z-Score Transformation}: Transforms the original angle matrix into
z-scores.
}
This process allows for the identification of invariant gene-gene
relationships by comparing them to a null distribution derived from the
permuted data.
}
\examples{
mat <- matrix(
 c(
     5, 3, 0, 0,
     0, 0, 0, 3,
     2, 1, 3, 4,
     0, 0, 1, 0,
     1, 2, 1, 2,
     3, 4, 3, 4
   ),
   nrow = 6, # 6 genes
   ncol = 4, # 4 cells
   byrow = TRUE
)

mat <- bigstatsr::FBM(nrow = nrow(mat), ncol = ncol(mat), init = mat)

# Run factorise with method "cosine" and a fixed seed
result_fbm <- factorise(mat, method = "cosine", seed = 1)
result_fbm[]
}
\seealso{
\code{\link{extract_angles}},
\code{\link{get_dstat}},
\code{\link[bigstatsr]{big_apply}},
\code{\link[bigstatsr]{FBM}}
}
