% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiFactor-methods.R, R/methods-getGraph.R
\name{MultiFactor-methods}
\alias{MultiFactor-methods}
\alias{levels.anansi::MultiFactor}
\alias{unfactor}
\alias{unfactor,anansi::MultiFactor-method}
\alias{getGraph.anansi::MultiFactor}
\title{Methods for MultiFactor S7 container class}
\arguments{
\item{...}{\verb{i,j} indices specifying elements to extract or replace. Indices
are numeric or character vectors or empty (missing) or NULL. Numeric
values are coerced to integer or whole numbers as by as.integer or for
large values by trunc (and hence truncated towards zero). Character
vectors will be matched to the names of the object.}

\item{value}{Replacement value, typically of same type as that which is to be
replaced.}

\item{exclude}{\code{NULL} or \verb{Named character list} of similar structure as
\code{levels(MultiFactor)}. Which levels to drop from output.}

\item{select}{\code{NULL} or \verb{Named character list} of similar structure as
\code{levels(MultiFactor)}. Which levels to keep in output.}

\item{use.names, ignore.mcols}{For compatibility, not used.}

\item{x}{\code{MultiFactor}}

\item{format}{\verb{Character scalar}, controls output format by package name.
\code{"igraph"} and \code{"graph"} are supported.}
}
\value{
A MultiFactor

a specified graph object.
}
\description{
\describe{
\item{\code{droplevels()} }{\code{droplevels(MultiFactor)} returns a \code{MultiFactor}
with unused levels removed, Analogous to the \code{factor} method.}
}
}
\details{
Only one of \code{select} and \code{exclude} should be provided, as they are
each others complement.
}
\examples{
# Setup
x <- MultiFactor(kegg_link())
x

# Basic properties
dim(x)
dimnames(x)

# Factor-like properties
head(levels(x)$ko)
droplevels(x)
head(unfactor(x)$ec2ko)

# Extract common output formats
getEdgeList(x)

droplevels(x, exclude = list(ko = "K00001"))
droplevels(x, select = list(ko = "K00001"))
# Generate an igraph object
g <- getGraph(x = kegg_link(), format = "igraph")
plot(g)

}
\seealso{
\code{\link[igraph:graph_from_data_frame]{igraph::graph_from_data_frame()}} and
\code{\link[igraph:as_graphnel]{igraph::as_graphnel()}}, which are used under the hood, from
\code{\link[igraph:aaa-igraph-package]{igraph::igraph()}} package.
}
