% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnansiWeb-methods.R
\name{AnansiWeb-methods}
\alias{AnansiWeb-methods}
\alias{show.anansi::AnansiWeb}
\alias{names.anansi::AnansiWeb}
\alias{dimnames.anansi::AnansiWeb}
\alias{dim.anansi::AnansiWeb}
\title{Methods for AnansiWeb S7 container class}
\arguments{
\item{x}{input, AnansiWeb object}
}
\value{
The desired information from an AnansiWeb object
}
\description{
Methods for AnansiWeb S7 container class
}
\examples{
# Setup
web <- randomWeb(n_samp = 36)

# Accessors
dimnames(web)
dim(web)
names(web)

# Getters and setters:

tableX(web)[1:5, 1:5]
tableY(web)[1:5, 1:5]
dictionary(web)
head(metadata(web))

# Assign some random metadata
metadata(web) <- data.frame(
    id = row.names(tableY(web)),
    a = rnorm(36),
    b = sample(c("a", "b"), 36, TRUE),
    row.names = "id"
)

# Coerce to list
weblist <- as.list(web)

# Coerce to Data.frame
webdf <- as.data.frame(web)

# Coerce to MultiAssayExperiment
mae <- asMAE(web)

# Coerce to TreeSummarizedExperiment
tse <- asTSE(web)
}
\seealso{
\itemize{
\item \code{\link[=weaveWeb]{weaveWeb()}}: for general use.
\item \link{AnansiWeb-pairwise}: for methods for pairwise operations
}
}
