% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{AnansiWeb}
\alias{AnansiWeb}
\title{AnansiWeb S7 container class}
\usage{
## Constructor for `AnansiWeb` objects
AnansiWeb(tableX, tableY, dictionary, metadata = data.frame())
}
\arguments{
\item{tableY, tableX}{A table containing features of interest. Rows should be
samples and columns should be features. Y and X refer to the position of
the features in a formula: Y ~ X.}

\item{dictionary}{A binary adjacency matrix of class \code{Matrix}, or coercible
to \code{Matrix}}

\item{metadata}{\code{list} of metadata. Optional.}
}
\value{
an \code{AnansiWeb} object, with sparse binary biadjacency matrix
with features from \code{y} as rows and features from \code{x} as columns in
\code{dictionary} slot.
}
\description{
\code{AnansiWeb} is an S7 class containing two feature tables as well as a
dictionary to link them. \code{AnansiWeb} is the main container that will
hold your input data throughout the \code{anansi} pipeline.

Typical use of the \code{anansi} package will involve generating an \code{AnansiWeb}
object using the \code{weaveWeb()} function.

The function \code{AnansiWeb()} constructs an \code{AnansiWeb} object from two
feature tables and an adjacency matrix.
}
\section{Slots}{

\describe{
\item{\code{tableY,tableX}}{Two \code{matrix} objects of measurements, data. Rows are
samples and columns are features. Access with \verb{@tableY} and \verb{@tableX}.}

\item{\code{dictionary}}{\code{Matrix}, binary adjacency matrix. Optionally sparse.
Typically generated using the \code{weaveWeb()} function. Access with
\verb{@dictionary}.}

\item{\code{metadata}}{Optional \code{data.frame} of sample metadata. Access with
\verb{@metadata}.}
}}

\examples{

# Use AnansiWeb() to construct an AnansiWeb object from components:
tX <- `dimnames<-`(replicate(5, (rnorm(36))),
    value = list(
        as.character(seq_len(36)),
        letters[1:5]
    )
)
tY <- `dimnames<-`(replicate(3, (rnorm(36))),
    value = list(
        as.character(seq_len(36)),
        LETTERS[1:3]
    )
)

d <- matrix(TRUE,
    nrow = NCOL(tY), ncol = NCOL(tX),

    # Note: Dictionary should have named dimensions
    dimnames = list(
        y_names = colnames(tY),
        x_names = colnames(tX)
    )
)
web <- AnansiWeb(tableX = tX, tableY = tY, dictionary = d)

}
\seealso{
\itemize{
\item \link{AnansiWeb-methods}
\item \link{randomAnansi}: For generation of random AnansiWeb objects.
\item \code{\link[=kegg_link]{kegg_link()}}: For examples of input for link argument.
}
}
