% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_general.R
\name{amplicanMap}
\alias{amplicanMap}
\title{Map events to their respective relative coordinates specified with
UPPER case.}
\usage{
amplicanMap(aln, cfgT)
}
\arguments{
\item{aln}{(data.frame) List of events to map to the relative coordinates.}

\item{cfgT}{(data.frame) config table}
}
\value{
(\code{\link[GenomicRanges]{GRanges}}) Same as events, but the coordinates are
relative to the expected cut sites.
}
\description{
Translate coordinates of \code{\link[GenomicRanges]{GRanges}} events so that they can be
relative to the amplicon. As point zero we assume first left sided UPPER case
letter in the
amplicon. Be weary that events for amplicons without expected cut sites are
filtered. Don't use this function, if you don't have expected cut sites
specified and don't use any of the metaplots.
}
\examples{
# example config
config <- read.csv(system.file("extdata", "config.csv",
                   package = "amplican"))
# example events
events <- read.csv(system.file("extdata", "results", "alignments",
                   "raw_events.csv", package = "amplican"))
# make events relative to the UPPER case
amplicanMap(events, config)

}
\seealso{
Other analysis steps: 
\code{\link{amplicanAlign}()},
\code{\link{amplicanConsensus}()},
\code{\link{amplicanFilter}()},
\code{\link{amplicanNormalize}()},
\code{\link{amplicanOverlap}()},
\code{\link{amplicanPipeline}()},
\code{\link{amplicanPipelineConservative}()},
\code{\link{amplicanReport}()},
\code{\link{amplicanSummarize}()}
}
\concept{analysis steps}
