% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alevinQCShiny.R
\name{qcShiny}
\alias{qcShiny}
\alias{alevinQCShiny}
\alias{alevinFryQCShiny}
\alias{simpleafQCShiny}
\title{Generate alevin/alevin-fry summary shiny app}
\usage{
alevinQCShiny(baseDir, sampleId, customCBList = list(), addStopButton = TRUE)

alevinFryQCShiny(mapDir, permitDir, quantDir, sampleId, addStopButton = TRUE)

simpleafQCShiny(simpleafQuantDir, sampleId, addStopButton = TRUE)
}
\arguments{
\item{baseDir}{(Only used for alevin output) Path to the output directory
from the alevin run (should be the directory containing the
\code{alevin} directory).}

\item{sampleId}{Sample ID, will be used set the title for the app.}

\item{customCBList}{Named list with custom set(s) of barcodes to provide
summary statistics/plots for, in addition to the whitelists generated by
alevin.}

\item{addStopButton}{Logical scalar. If \code{TRUE} (default), will add a
dropdown menu with a button to stop the app (by calling
\code{shiny::stopApp}) and return a list with the information displayed
in the app.}

\item{mapDir}{(Only used for alevin-fry output) Path to the output directory
from the salmon alevin run (should be the directory containing the
\code{map.rad} file).}

\item{permitDir}{(Only used for alevin-fry output) Path to the output
directory from the permit list generation step (should be
the directory containing the \code{all_freq.tsv} file).}

\item{quantDir}{(Only used for alevin-fry output) Path to the output
directory from the alevin-fry quantification step (should be
the directory containing the \code{alevin} directory).}

\item{simpleafQuantDir}{(Only used for simpleaf output) Path to the output
directory from the simpleaf run (should be the directory containing the
\code{af_map} and \code{af_quant} directories).}
}
\value{
A shiny app.
}
\description{
Generate a shiny app summarizing the main aspects of an alevin/alevin-fry
quantification run. The app generation assumes that alevin has been run
with the --dumpFeatures flag to generate the necessary output files.
}
\examples{
app <- alevinQCShiny(
    baseDir = system.file("extdata/alevin_example_v0.14",
                          package = "alevinQC"),
    sampleId = "example")
if (interactive()) {
    shiny::runApp(app)
}

app <- alevinFryQCShiny(
    mapDir = system.file("extdata/alevinfry_example_v0.5.0/map",
                         package = "alevinQC"),
    permitDir = system.file("extdata/alevinfry_example_v0.5.0/permit",
                            package = "alevinQC"),
    quantDir = system.file("extdata/alevinfry_example_v0.5.0/quant",
                           package = "alevinQC"),
    sampleId = "example")
if (interactive()) {
    shiny::runApp(app)
}

app <- simpleafQCShiny(
    simpleafQuantDir = system.file("extdata/alevinfry_example_piscem_v0.6.0",
                                   package = "alevinQC"),
    sampleId = "example")
if (interactive()) {
    shiny::runApp(app)
}

}
\author{
Charlotte Soneson
}
