% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlevinKneeRaw.R
\name{plotAlevinKneeRaw}
\alias{plotAlevinKneeRaw}
\title{Knee plot of raw cell barcode frequencies}
\usage{
plotAlevinKneeRaw(cbTable, firstSelColName = "inFirstWhiteList")
}
\arguments{
\item{cbTable}{\code{data.frame} with raw barcode frequencies (such as the
\code{cbTable} returned by \code{readAlevinQC} or
\code{readAlevinFryQC}).}

\item{firstSelColName}{Character scalar indicating the name of the logical
column in \code{cbTable} that corresponds to the original selection of
barcodes for quantification.}
}
\value{
A ggplot object
}
\description{
Plot the raw cell barcode frequencies in decreasing order, and indicate a
predetermined breakpoint (indicating barcodes included in the original
whitelist) using color as well as a label.
}
\examples{
alevin <- readAlevinQC(system.file("extdata/alevin_example_v0.14",
                                   package = "alevinQC"))
plotAlevinKneeRaw(alevin$cbTable)

}
\author{
Charlotte Soneson
}
