% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkAlevinFryInputFiles.R
\name{checkAlevinFryInputFiles}
\alias{checkAlevinFryInputFiles}
\title{Check that all required input files are available for alevin-fry}
\usage{
checkAlevinFryInputFiles(mapDir, permitDir, quantDir)
}
\arguments{
\item{mapDir}{Path to the directory containing the map.rad file}

\item{permitDir}{Path to the output directory of the alevin-fry
generate-permit-list command.}

\item{quantDir}{Path to the output of the alevin-fry quant command.}
}
\value{
Returns nothing, raises an error if any of the required files are
  missing.
}
\description{
Check that all required input files are available for alevin-fry
}
\examples{
checkAlevinFryInputFiles(
    mapDir = system.file("extdata/alevinfry_example_v0.5.0/map",
                         package = "alevinQC"),
    permitDir = system.file("extdata/alevinfry_example_v0.5.0/permit",
                            package = "alevinQC"),
    quantDir = system.file("extdata/alevinfry_example_v0.5.0/quant",
                           package = "alevinQC"))

}
\author{
Charlotte Soneson
}
