% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveXStringSet.R
\name{saveObject,XStringSet-method}
\alias{saveObject,XStringSet-method}
\alias{stageObject,XStringSet-method}
\title{Save a XStringSet to disk}
\usage{
\S4method{saveObject}{XStringSet}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{XStringSet} or any of its subclasses such as a \linkS4class{QualityScaledXStringSet}.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
The contents of \code{x} are saved into a \code{path}, and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{XStringSet} to its on-disk representation.
}
\examples{
library(Biostrings)
stuff <- DNAStringSet(c("AAA", "CC", "G", "TTTT"))

tmp <- tempfile()
saveObject(stuff, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readXStringSet}}, to read the XStringSet back into the R session.
}
\author{
Aaron Lun
}
